@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSecurityDomainPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security domain properties information for Cloud HSM cluster
 * @property activationStatus status of security domain activation
 * @property fipsState FIPS state information for security domain
 */
public data class CloudHsmClusterSecurityDomainPropertiesArgs(
    public val activationStatus: Output<String>? = null,
    public val fipsState: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSecurityDomainPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSecurityDomainPropertiesArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmClusterSecurityDomainPropertiesArgs.builder()
            .activationStatus(activationStatus?.applyValue({ args0 -> args0 }))
            .fipsState(fipsState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudHsmClusterSecurityDomainPropertiesArgs].
 */
@PulumiTagMarker
public class CloudHsmClusterSecurityDomainPropertiesArgsBuilder internal constructor() {
    private var activationStatus: Output<String>? = null

    private var fipsState: Output<Int>? = null

    /**
     * @param value status of security domain activation
     */
    @JvmName("lbjwrshlqlieecwp")
    public suspend fun activationStatus(`value`: Output<String>) {
        this.activationStatus = value
    }

    /**
     * @param value FIPS state information for security domain
     */
    @JvmName("tndauxjnscohjcak")
    public suspend fun fipsState(`value`: Output<Int>) {
        this.fipsState = value
    }

    /**
     * @param value status of security domain activation
     */
    @JvmName("dnqpehrbsdrejplg")
    public suspend fun activationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activationStatus = mapped
    }

    /**
     * @param value FIPS state information for security domain
     */
    @JvmName("nldnowiwkoaumipw")
    public suspend fun fipsState(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fipsState = mapped
    }

    internal fun build(): CloudHsmClusterSecurityDomainPropertiesArgs =
        CloudHsmClusterSecurityDomainPropertiesArgs(
            activationStatus = activationStatus,
            fipsState = fipsState,
        )
}
