@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Cloud HSM Properties
 * @property fqdn FQDN of the Cloud HSM
 * @property state The Cloud HSM State
 * @property stateMessage The Cloud HSM State message
 */
public data class CloudHsmPropertiesArgs(
    public val fqdn: Output<String>? = null,
    public val state: Output<String>? = null,
    public val stateMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmPropertiesArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.CloudHsmPropertiesArgs.builder()
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .stateMessage(stateMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudHsmPropertiesArgs].
 */
@PulumiTagMarker
public class CloudHsmPropertiesArgsBuilder internal constructor() {
    private var fqdn: Output<String>? = null

    private var state: Output<String>? = null

    private var stateMessage: Output<String>? = null

    /**
     * @param value FQDN of the Cloud HSM
     */
    @JvmName("opiddrstewxtsvwt")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value The Cloud HSM State
     */
    @JvmName("hokjrwelnyegyfro")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The Cloud HSM State message
     */
    @JvmName("qgjavksddqyjkqpy")
    public suspend fun stateMessage(`value`: Output<String>) {
        this.stateMessage = value
    }

    /**
     * @param value FQDN of the Cloud HSM
     */
    @JvmName("ykvsttynvnnsbacu")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value The Cloud HSM State
     */
    @JvmName("kbnijavitxnvsjaq")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The Cloud HSM State message
     */
    @JvmName("vovyatwxwmluluya")
    public suspend fun stateMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stateMessage = mapped
    }

    internal fun build(): CloudHsmPropertiesArgs = CloudHsmPropertiesArgs(
        fqdn = fqdn,
        state = state,
        stateMessage = stateMessage,
    )
}
