@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs

import com.pulumi.azurenative.hardwaresecuritymodules.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection resource.
 * @property etag Modified whenever there is a change in the state of private endpoint connection.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 */
public data class PrivateEndpointConnectionArgs(
    public val etag: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.inputs.PrivateEndpointConnectionArgs.builder()
            .etag(etag?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var etag: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    /**
     * @param value Modified whenever there is a change in the state of private endpoint connection.
     */
    @JvmName("awrhdoajhuiqwcst")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("mpssdydikawbbccr")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Modified whenever there is a change in the state of private endpoint connection.
     */
    @JvmName("lbpvfitddwmhtimw")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("rrdgfmphlkmgqlok")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("dofjsjanmoydcfpq")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        etag = etag,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState ?: throw
            PulumiNullFieldException("privateLinkServiceConnectionState"),
    )
}
