@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The network interface definition.
 * @property id The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
 * @property privateIpAddress Private Ip address of the interface
 */
public data class NetworkInterfaceResponse(
    public val id: String,
    public val privateIpAddress: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.NetworkInterfaceResponse):
            NetworkInterfaceResponse = NetworkInterfaceResponse(
            id = javaType.id(),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
