@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.ClusterPoolArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesComputeProfileArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesComputeProfileArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesLogAnalyticsProfileArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesLogAnalyticsProfileArgsBuilder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesNetworkProfileArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.ClusterPoolResourcePropertiesNetworkProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cluster pool.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Example Usage
 * ### ClusterPoolPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterPool = new AzureNative.HDInsight.ClusterPool("clusterPool", new()
 *     {
 *         ClusterPoolName = "clusterpool1",
 *         ClusterPoolProfile = new AzureNative.HDInsight.Inputs.ClusterPoolResourcePropertiesClusterPoolProfileArgs
 *         {
 *             ClusterPoolVersion = "1.2",
 *         },
 *         ComputeProfile = new AzureNative.HDInsight.Inputs.ClusterPoolResourcePropertiesComputeProfileArgs
 *         {
 *             VmSize = "Standard_D3_v2",
 *         },
 *         Location = "West US 2",
 *         ResourceGroupName = "hiloResourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewClusterPool(ctx, "clusterPool", &hdinsight.ClusterPoolArgs{
 * 			ClusterPoolName: pulumi.String("clusterpool1"),
 * 			ClusterPoolProfile: &hdinsight.ClusterPoolResourcePropertiesClusterPoolProfileArgs{
 * 				ClusterPoolVersion: pulumi.String("1.2"),
 * 			},
 * 			ComputeProfile: &hdinsight.ClusterPoolResourcePropertiesComputeProfileArgs{
 * 				VmSize: pulumi.String("Standard_D3_v2"),
 * 			},
 * 			Location:          pulumi.String("West US 2"),
 * 			ResourceGroupName: pulumi.String("hiloResourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.ClusterPool;
 * import com.pulumi.azurenative.hdinsight.ClusterPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterPool = new ClusterPool("clusterPool", ClusterPoolArgs.builder()
 *             .clusterPoolName("clusterpool1")
 *             .clusterPoolProfile(Map.of("clusterPoolVersion", "1.2"))
 *             .computeProfile(Map.of("vmSize", "Standard_D3_v2"))
 *             .location("West US 2")
 *             .resourceGroupName("hiloResourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:ClusterPool clusterpool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusterpools/{clusterPoolName}
 * ```
 * @property clusterPoolName The name of the cluster pool.
 * @property clusterPoolProfile CLuster pool profile.
 * @property computeProfile CLuster pool compute profile.
 * @property location The geo-location where the resource lives
 * @property logAnalyticsProfile Cluster pool log analytics profile to enable OMS agent for AKS cluster.
 * @property managedResourceGroupName A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
 * @property networkProfile Cluster pool network profile.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ClusterPoolArgs(
    public val clusterPoolName: Output<String>? = null,
    public val clusterPoolProfile: Output<ClusterPoolResourcePropertiesClusterPoolProfileArgs>? =
        null,
    public val computeProfile: Output<ClusterPoolResourcePropertiesComputeProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val logAnalyticsProfile: Output<ClusterPoolResourcePropertiesLogAnalyticsProfileArgs>? =
        null,
    public val managedResourceGroupName: Output<String>? = null,
    public val networkProfile: Output<ClusterPoolResourcePropertiesNetworkProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.ClusterPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.ClusterPoolArgs =
        com.pulumi.azurenative.hdinsight.ClusterPoolArgs.builder()
            .clusterPoolName(clusterPoolName?.applyValue({ args0 -> args0 }))
            .clusterPoolProfile(
                clusterPoolProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .computeProfile(computeProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logAnalyticsProfile(
                logAnalyticsProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managedResourceGroupName(managedResourceGroupName?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterPoolArgs].
 */
@PulumiTagMarker
public class ClusterPoolArgsBuilder internal constructor() {
    private var clusterPoolName: Output<String>? = null

    private var clusterPoolProfile: Output<ClusterPoolResourcePropertiesClusterPoolProfileArgs>? =
        null

    private var computeProfile: Output<ClusterPoolResourcePropertiesComputeProfileArgs>? = null

    private var location: Output<String>? = null

    private var logAnalyticsProfile: Output<ClusterPoolResourcePropertiesLogAnalyticsProfileArgs>? =
        null

    private var managedResourceGroupName: Output<String>? = null

    private var networkProfile: Output<ClusterPoolResourcePropertiesNetworkProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the cluster pool.
     */
    @JvmName("hprdvsijwjwyntoo")
    public suspend fun clusterPoolName(`value`: Output<String>) {
        this.clusterPoolName = value
    }

    /**
     * @param value CLuster pool profile.
     */
    @JvmName("xtxahojwsamgrcuo")
    public suspend
    fun clusterPoolProfile(`value`: Output<ClusterPoolResourcePropertiesClusterPoolProfileArgs>) {
        this.clusterPoolProfile = value
    }

    /**
     * @param value CLuster pool compute profile.
     */
    @JvmName("ipgmauiexbhgyong")
    public suspend
    fun computeProfile(`value`: Output<ClusterPoolResourcePropertiesComputeProfileArgs>) {
        this.computeProfile = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("awmhpvqvhrdrjuyq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Cluster pool log analytics profile to enable OMS agent for AKS cluster.
     */
    @JvmName("hkvraqchaivnsjxq")
    public suspend
    fun logAnalyticsProfile(`value`: Output<ClusterPoolResourcePropertiesLogAnalyticsProfileArgs>) {
        this.logAnalyticsProfile = value
    }

    /**
     * @param value A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
     */
    @JvmName("xchqwmagiehwxxhf")
    public suspend fun managedResourceGroupName(`value`: Output<String>) {
        this.managedResourceGroupName = value
    }

    /**
     * @param value Cluster pool network profile.
     */
    @JvmName("hqxerfsyajrxibqh")
    public suspend
    fun networkProfile(`value`: Output<ClusterPoolResourcePropertiesNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjhqjsiypvkvbtdp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jefecdchlchgkbhu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the cluster pool.
     */
    @JvmName("jipyaqipjiyvedrg")
    public suspend fun clusterPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterPoolName = mapped
    }

    /**
     * @param value CLuster pool profile.
     */
    @JvmName("pygitggvpovfbnqh")
    public suspend
    fun clusterPoolProfile(`value`: ClusterPoolResourcePropertiesClusterPoolProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterPoolProfile = mapped
    }

    /**
     * @param argument CLuster pool profile.
     */
    @JvmName("kxhrgpsqukielmiv")
    public suspend
    fun clusterPoolProfile(argument: suspend ClusterPoolResourcePropertiesClusterPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPoolResourcePropertiesClusterPoolProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clusterPoolProfile = mapped
    }

    /**
     * @param value CLuster pool compute profile.
     */
    @JvmName("sdvonnswlrggclyy")
    public suspend fun computeProfile(`value`: ClusterPoolResourcePropertiesComputeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProfile = mapped
    }

    /**
     * @param argument CLuster pool compute profile.
     */
    @JvmName("fpitvnpcsuhclgsp")
    public suspend
    fun computeProfile(argument: suspend ClusterPoolResourcePropertiesComputeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPoolResourcePropertiesComputeProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.computeProfile = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pvxnbqsksywhhdhy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Cluster pool log analytics profile to enable OMS agent for AKS cluster.
     */
    @JvmName("ktxbspdcsospkijj")
    public suspend
    fun logAnalyticsProfile(`value`: ClusterPoolResourcePropertiesLogAnalyticsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsProfile = mapped
    }

    /**
     * @param argument Cluster pool log analytics profile to enable OMS agent for AKS cluster.
     */
    @JvmName("srukersolucmoybs")
    public suspend
    fun logAnalyticsProfile(argument: suspend ClusterPoolResourcePropertiesLogAnalyticsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPoolResourcePropertiesLogAnalyticsProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logAnalyticsProfile = mapped
    }

    /**
     * @param value A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
     */
    @JvmName("hwdcgykbuppbwgmq")
    public suspend fun managedResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupName = mapped
    }

    /**
     * @param value Cluster pool network profile.
     */
    @JvmName("nqkhexowensedqvv")
    public suspend fun networkProfile(`value`: ClusterPoolResourcePropertiesNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Cluster pool network profile.
     */
    @JvmName("vnvxwttlphqshdlh")
    public suspend
    fun networkProfile(argument: suspend ClusterPoolResourcePropertiesNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterPoolResourcePropertiesNetworkProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kpkpthmgqhdrdayr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nwihqjhtcivyccyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("aqnrbxooclntfevk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterPoolArgs = ClusterPoolArgs(
        clusterPoolName = clusterPoolName,
        clusterPoolProfile = clusterPoolProfile,
        computeProfile = computeProfile,
        location = location,
        logAnalyticsProfile = logAnalyticsProfile,
        managedResourceGroupName = managedResourceGroupName,
        networkProfile = networkProfile,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
