@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.hdinsight.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2023-04-15-preview, 2023-08-15-preview.
 * ## Example Usage
 * ### Approve a private endpoint connection manually.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.HDInsight.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ClusterName = "cluster1",
 *         PrivateEndpointConnectionName = "testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2",
 *         PrivateLinkServiceConnectionState = new AzureNative.HDInsight.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "update it from pending to approved.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &hdinsight.PrivateEndpointConnectionArgs{
 * 			ClusterName:                   pulumi.String("cluster1"),
 * 			PrivateEndpointConnectionName: pulumi.String("testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2"),
 * 			PrivateLinkServiceConnectionState: &hdinsight.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("update it from pending to approved."),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.PrivateEndpointConnection;
 * import com.pulumi.azurenative.hdinsight.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .clusterName("cluster1")
 *             .privateEndpointConnectionName("testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "update it from pending to approved."),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:PrivateEndpointConnection testprivateep.b3bf5fed-9b12-4560-b7d0-2abe1bba07e2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property clusterName The name of the cluster.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState The private link service connection state.
 * @property resourceGroupName The name of the resource group.
 */
public data class PrivateEndpointConnectionArgs(
    public val clusterName: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.hdinsight.PrivateEndpointConnectionArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("bajubcplgaeaejtv")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("yvcfkolwfdlikefe")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value The private link service connection state.
     */
    @JvmName("hfoehkwfkaiterfu")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hvfjpnrtsjruhbwe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("buixdctwxuhqlart")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("tqfgoshmulfsmvpt")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The private link service connection state.
     */
    @JvmName("jkcuoifnwxruuknk")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The private link service connection state.
     */
    @JvmName("ohvpvvyfpmxxyxbp")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wjdmtfixmicgehdw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        clusterName = clusterName,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
