@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.enums.ResourceIdentityType):
            ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
