@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.AutoscaleRecurrenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schedule-based autoscale request parameters
 * @property schedule Array of schedule-based autoscale rules
 * @property timeZone The time zone for the autoscale schedule times
 */
public data class AutoscaleRecurrenceArgs(
    public val schedule: Output<List<AutoscaleScheduleArgs>>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.AutoscaleRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.AutoscaleRecurrenceArgs =
        com.pulumi.azurenative.hdinsight.inputs.AutoscaleRecurrenceArgs.builder()
            .schedule(
                schedule?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoscaleRecurrenceArgs].
 */
@PulumiTagMarker
public class AutoscaleRecurrenceArgsBuilder internal constructor() {
    private var schedule: Output<List<AutoscaleScheduleArgs>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Array of schedule-based autoscale rules
     */
    @JvmName("vujcgudhlvhlytpi")
    public suspend fun schedule(`value`: Output<List<AutoscaleScheduleArgs>>) {
        this.schedule = value
    }

    @JvmName("sxhyxvdrkbgpnlna")
    public suspend fun schedule(vararg values: Output<AutoscaleScheduleArgs>) {
        this.schedule = Output.all(values.asList())
    }

    /**
     * @param values Array of schedule-based autoscale rules
     */
    @JvmName("aemnbdyquxqqlcwg")
    public suspend fun schedule(values: List<Output<AutoscaleScheduleArgs>>) {
        this.schedule = Output.all(values)
    }

    /**
     * @param value The time zone for the autoscale schedule times
     */
    @JvmName("tngehxboauicgsrk")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Array of schedule-based autoscale rules
     */
    @JvmName("grbxksbenvyiwuom")
    public suspend fun schedule(`value`: List<AutoscaleScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Array of schedule-based autoscale rules
     */
    @JvmName("fdbmxekcxrxffbya")
    public suspend fun schedule(argument: List<suspend AutoscaleScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutoscaleScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param argument Array of schedule-based autoscale rules
     */
    @JvmName("kgftsiqqjjjcxawu")
    public suspend fun schedule(vararg argument: suspend AutoscaleScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AutoscaleScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param argument Array of schedule-based autoscale rules
     */
    @JvmName("qcquqjvesvcixpqo")
    public suspend fun schedule(argument: suspend AutoscaleScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AutoscaleScheduleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param values Array of schedule-based autoscale rules
     */
    @JvmName("flixymhxiswnylaj")
    public suspend fun schedule(vararg values: AutoscaleScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The time zone for the autoscale schedule times
     */
    @JvmName("doyfnfmnwdmojadx")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): AutoscaleRecurrenceArgs = AutoscaleRecurrenceArgs(
        schedule = schedule,
        timeZone = timeZone,
    )
}
