@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ComputeIsolationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The compute isolation properties.
 * @property enableComputeIsolation The flag indicates whether enable compute isolation or not.
 * @property hostSku The host sku.
 */
public data class ComputeIsolationPropertiesArgs(
    public val enableComputeIsolation: Output<Boolean>? = null,
    public val hostSku: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ComputeIsolationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ComputeIsolationPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.ComputeIsolationPropertiesArgs.builder()
            .enableComputeIsolation(enableComputeIsolation?.applyValue({ args0 -> args0 }))
            .hostSku(hostSku?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeIsolationPropertiesArgs].
 */
@PulumiTagMarker
public class ComputeIsolationPropertiesArgsBuilder internal constructor() {
    private var enableComputeIsolation: Output<Boolean>? = null

    private var hostSku: Output<String>? = null

    /**
     * @param value The flag indicates whether enable compute isolation or not.
     */
    @JvmName("jfngmekxfcttluvv")
    public suspend fun enableComputeIsolation(`value`: Output<Boolean>) {
        this.enableComputeIsolation = value
    }

    /**
     * @param value The host sku.
     */
    @JvmName("pfxirthbsobggqqc")
    public suspend fun hostSku(`value`: Output<String>) {
        this.hostSku = value
    }

    /**
     * @param value The flag indicates whether enable compute isolation or not.
     */
    @JvmName("vaihjsaqhmngvlxd")
    public suspend fun enableComputeIsolation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableComputeIsolation = mapped
    }

    /**
     * @param value The host sku.
     */
    @JvmName("jgbmpukfsdmxbbhu")
    public suspend fun hostSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostSku = mapped
    }

    internal fun build(): ComputeIsolationPropertiesArgs = ComputeIsolationPropertiesArgs(
        enableComputeIsolation = enableComputeIsolation,
        hostSku = hostSku,
    )
}
