@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.DataDisksGroupsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data disks groups for the role.
 * @property disksPerNode The number of disks per node.
 */
public data class DataDisksGroupsArgs(
    public val disksPerNode: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.DataDisksGroupsArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.DataDisksGroupsArgs =
        com.pulumi.azurenative.hdinsight.inputs.DataDisksGroupsArgs.builder()
            .disksPerNode(disksPerNode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataDisksGroupsArgs].
 */
@PulumiTagMarker
public class DataDisksGroupsArgsBuilder internal constructor() {
    private var disksPerNode: Output<Int>? = null

    /**
     * @param value The number of disks per node.
     */
    @JvmName("ioocvpjatrncqrxq")
    public suspend fun disksPerNode(`value`: Output<Int>) {
        this.disksPerNode = value
    }

    /**
     * @param value The number of disks per node.
     */
    @JvmName("mcdqvfmodbwqumld")
    public suspend fun disksPerNode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksPerNode = mapped
    }

    internal fun build(): DataDisksGroupsArgs = DataDisksGroupsArgs(
        disksPerNode = disksPerNode,
    )
}
