@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.GetClusterPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterPoolName The name of the cluster pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetClusterPoolPlainArgs(
    public val clusterPoolName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.GetClusterPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.GetClusterPoolPlainArgs =
        com.pulumi.azurenative.hdinsight.inputs.GetClusterPoolPlainArgs.builder()
            .clusterPoolName(clusterPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterPoolPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPoolPlainArgsBuilder internal constructor() {
    private var clusterPoolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster pool.
     */
    @JvmName("uukqfbkgvptwkcpy")
    public suspend fun clusterPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lwymemamtlkewibu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClusterPoolPlainArgs = GetClusterPoolPlainArgs(
        clusterPoolName = clusterPoolName ?: throw PulumiNullFieldException("clusterPoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
