@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.HardwareProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The hardware profile.
 * @property vmSize The size of the VM
 */
public data class HardwareProfileArgs(
    public val vmSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.HardwareProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.HardwareProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.HardwareProfileArgs.builder()
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HardwareProfileArgs].
 */
@PulumiTagMarker
public class HardwareProfileArgsBuilder internal constructor() {
    private var vmSize: Output<String>? = null

    /**
     * @param value The size of the VM
     */
    @JvmName("yajhmscvvflvrsqn")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The size of the VM
     */
    @JvmName("loirvjnupjbbefcv")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): HardwareProfileArgs = HardwareProfileArgs(
        vmSize = vmSize,
    )
}
