@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.IPConfigurationArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.PrivateIPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The ip configurations for the private link service.
 * @property name The name of private link IP configuration.
 * @property primary Indicates whether this IP configuration is primary for the corresponding NIC.
 * @property privateIPAddress The IP address.
 * @property privateIPAllocationMethod The method that private IP address is allocated.
 * @property subnet The subnet resource id.
 */
public data class IPConfigurationArgs(
    public val name: Output<String>,
    public val primary: Output<Boolean>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, PrivateIPAllocationMethod>>? = null,
    public val subnet: Output<ResourceIdArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.IPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.IPConfigurationArgs =
        com.pulumi.azurenative.hdinsight.inputs.IPConfigurationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IPConfigurationArgs].
 */
@PulumiTagMarker
public class IPConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, PrivateIPAllocationMethod>>? = null

    private var subnet: Output<ResourceIdArgs>? = null

    /**
     * @param value The name of private link IP configuration.
     */
    @JvmName("mltngrnadqmcjoho")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether this IP configuration is primary for the corresponding NIC.
     */
    @JvmName("ssyipsmsogojgabe")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value The IP address.
     */
    @JvmName("nhhsfavewtuuqptj")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The method that private IP address is allocated.
     */
    @JvmName("ddsxtsplwwilcfgt")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, PrivateIPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value The subnet resource id.
     */
    @JvmName("cgxbheclqcbihusb")
    public suspend fun subnet(`value`: Output<ResourceIdArgs>) {
        this.subnet = value
    }

    /**
     * @param value The name of private link IP configuration.
     */
    @JvmName("wyqygmstpxsbveni")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether this IP configuration is primary for the corresponding NIC.
     */
    @JvmName("wyfbagfoaokfufwu")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The IP address.
     */
    @JvmName("vjgakcnaffhrbwyi")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The method that private IP address is allocated.
     */
    @JvmName("cxgdqbdnkxgykple")
    public suspend
    fun privateIPAllocationMethod(`value`: Either<String, PrivateIPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The method that private IP address is allocated.
     */
    @JvmName("kfxgrulksqghjvwy")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateIPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The method that private IP address is allocated.
     */
    @JvmName("ydabmncdmkbgyiwf")
    public fun privateIPAllocationMethod(`value`: PrivateIPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, PrivateIPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The subnet resource id.
     */
    @JvmName("waswsjnyhqjivaqv")
    public suspend fun subnet(`value`: ResourceIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The subnet resource id.
     */
    @JvmName("grjkgeflxfjgiohg")
    public suspend fun subnet(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): IPConfigurationArgs = IPConfigurationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        primary = primary,
        privateIPAddress = privateIPAddress,
        privateIPAllocationMethod = privateIPAllocationMethod,
        subnet = subnet,
    )
}
