@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.KafkaRestPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The kafka rest proxy configuration which contains AAD security group information.
 * @property clientGroupInfo The information of AAD security group.
 * @property configurationOverride The configurations that need to be overriden.
 */
public data class KafkaRestPropertiesArgs(
    public val clientGroupInfo: Output<ClientGroupInfoArgs>? = null,
    public val configurationOverride: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.KafkaRestPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.KafkaRestPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.KafkaRestPropertiesArgs.builder()
            .clientGroupInfo(clientGroupInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .configurationOverride(
                configurationOverride?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KafkaRestPropertiesArgs].
 */
@PulumiTagMarker
public class KafkaRestPropertiesArgsBuilder internal constructor() {
    private var clientGroupInfo: Output<ClientGroupInfoArgs>? = null

    private var configurationOverride: Output<Map<String, String>>? = null

    /**
     * @param value The information of AAD security group.
     */
    @JvmName("whagrykblklixish")
    public suspend fun clientGroupInfo(`value`: Output<ClientGroupInfoArgs>) {
        this.clientGroupInfo = value
    }

    /**
     * @param value The configurations that need to be overriden.
     */
    @JvmName("uwofedtwasbhbqvi")
    public suspend fun configurationOverride(`value`: Output<Map<String, String>>) {
        this.configurationOverride = value
    }

    /**
     * @param value The information of AAD security group.
     */
    @JvmName("kvusrlkgamujhylm")
    public suspend fun clientGroupInfo(`value`: ClientGroupInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientGroupInfo = mapped
    }

    /**
     * @param argument The information of AAD security group.
     */
    @JvmName("xlvdtqfqclgpoiia")
    public suspend fun clientGroupInfo(argument: suspend ClientGroupInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ClientGroupInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientGroupInfo = mapped
    }

    /**
     * @param value The configurations that need to be overriden.
     */
    @JvmName("ksiuiitheeestfrn")
    public suspend fun configurationOverride(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationOverride = mapped
    }

    /**
     * @param values The configurations that need to be overriden.
     */
    @JvmName("tuevnrxudebcdgdp")
    public fun configurationOverride(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationOverride = mapped
    }

    internal fun build(): KafkaRestPropertiesArgs = KafkaRestPropertiesArgs(
        clientGroupInfo = clientGroupInfo,
        configurationOverride = configurationOverride,
    )
}
