@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.LinuxOperatingSystemProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The ssh username, password, and ssh public key.
 * @property password The password.
 * @property sshProfile The SSH profile.
 * @property username The username.
 */
public data class LinuxOperatingSystemProfileArgs(
    public val password: Output<String>? = null,
    public val sshProfile: Output<SshProfileArgs>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.LinuxOperatingSystemProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.LinuxOperatingSystemProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.LinuxOperatingSystemProfileArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .sshProfile(sshProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinuxOperatingSystemProfileArgs].
 */
@PulumiTagMarker
public class LinuxOperatingSystemProfileArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var sshProfile: Output<SshProfileArgs>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password.
     */
    @JvmName("htmikcijawkhmwko")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The SSH profile.
     */
    @JvmName("ffhovkxgfpchermo")
    public suspend fun sshProfile(`value`: Output<SshProfileArgs>) {
        this.sshProfile = value
    }

    /**
     * @param value The username.
     */
    @JvmName("sssttsynyidvmvss")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password.
     */
    @JvmName("erhesborlkorcavw")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The SSH profile.
     */
    @JvmName("pmwsdvyitrkamkpf")
    public suspend fun sshProfile(`value`: SshProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshProfile = mapped
    }

    /**
     * @param argument The SSH profile.
     */
    @JvmName("cyaphldyaijbgjyq")
    public suspend fun sshProfile(argument: suspend SshProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SshProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sshProfile = mapped
    }

    /**
     * @param value The username.
     */
    @JvmName("nxupygriwxnjghoe")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): LinuxOperatingSystemProfileArgs = LinuxOperatingSystemProfileArgs(
        password = password,
        sshProfile = sshProfile,
        username = username,
    )
}
