@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ScriptActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a script action on role on the cluster.
 * @property name The name of the script action.
 * @property parameters The parameters for the script provided.
 * @property uri The URI to the script.
 */
public data class ScriptActionArgs(
    public val name: Output<String>,
    public val parameters: Output<String>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ScriptActionArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ScriptActionArgs =
        com.pulumi.azurenative.hdinsight.inputs.ScriptActionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptActionArgs].
 */
@PulumiTagMarker
public class ScriptActionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var parameters: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The name of the script action.
     */
    @JvmName("hqydapeyaeykmogo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters for the script provided.
     */
    @JvmName("scdwaigfdtpcrwka")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value The URI to the script.
     */
    @JvmName("jstjeppynimseygi")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The name of the script action.
     */
    @JvmName("korgfwafdfnwinws")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters for the script provided.
     */
    @JvmName("wyprnfkftjyfvtrm")
    public suspend fun parameters(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The URI to the script.
     */
    @JvmName("hxnqkumuchbnvmtb")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ScriptActionArgs = ScriptActionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters ?: throw PulumiNullFieldException("parameters"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
