@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.SshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SSH public key for the cluster nodes.
 * @property certificateData The certificate for SSH.
 */
public data class SshPublicKeyArgs(
    public val certificateData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.SshPublicKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.SshPublicKeyArgs =
        com.pulumi.azurenative.hdinsight.inputs.SshPublicKeyArgs.builder()
            .certificateData(certificateData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshPublicKeyArgs].
 */
@PulumiTagMarker
public class SshPublicKeyArgsBuilder internal constructor() {
    private var certificateData: Output<String>? = null

    /**
     * @param value The certificate for SSH.
     */
    @JvmName("brakmfftlmikdcyv")
    public suspend fun certificateData(`value`: Output<String>) {
        this.certificateData = value
    }

    /**
     * @param value The certificate for SSH.
     */
    @JvmName("wfsdcxqkmsniildy")
    public suspend fun certificateData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateData = mapped
    }

    internal fun build(): SshPublicKeyArgs = SshPublicKeyArgs(
        certificateData = certificateData,
    )
}
