@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.StorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The storage Account.
 * @property container The container in the storage account, only to be specified for WASB storage accounts.
 * @property fileSystem The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
 * @property fileshare The file share name.
 * @property isDefault Whether or not the storage account is the default storage account.
 * @property key The storage account access key.
 * @property msiResourceId The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
 * @property name The name of the storage account.
 * @property resourceId The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
 * @property saskey The shared access signature key.
 */
public data class StorageAccountArgs(
    public val container: Output<String>? = null,
    public val fileSystem: Output<String>? = null,
    public val fileshare: Output<String>? = null,
    public val isDefault: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val msiResourceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val saskey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.StorageAccountArgs =
        com.pulumi.azurenative.hdinsight.inputs.StorageAccountArgs.builder()
            .container(container?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0 }))
            .fileshare(fileshare?.applyValue({ args0 -> args0 }))
            .isDefault(isDefault?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .msiResourceId(msiResourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .saskey(saskey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var container: Output<String>? = null

    private var fileSystem: Output<String>? = null

    private var fileshare: Output<String>? = null

    private var isDefault: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var msiResourceId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var saskey: Output<String>? = null

    /**
     * @param value The container in the storage account, only to be specified for WASB storage accounts.
     */
    @JvmName("uxosnccudmytvyjv")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
     */
    @JvmName("jbqefxmfotkdhlqw")
    public suspend fun fileSystem(`value`: Output<String>) {
        this.fileSystem = value
    }

    /**
     * @param value The file share name.
     */
    @JvmName("vpnbosdjkiuhjtej")
    public suspend fun fileshare(`value`: Output<String>) {
        this.fileshare = value
    }

    /**
     * @param value Whether or not the storage account is the default storage account.
     */
    @JvmName("cdbfsaapkfvpdflw")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value The storage account access key.
     */
    @JvmName("pdylorkaovsyqdaq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
     */
    @JvmName("waayagiewlibcxyu")
    public suspend fun msiResourceId(`value`: Output<String>) {
        this.msiResourceId = value
    }

    /**
     * @param value The name of the storage account.
     */
    @JvmName("jhmadwpucijcowcf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
     */
    @JvmName("lbhxgmcnnaibtqad")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The shared access signature key.
     */
    @JvmName("slcykutmyodrjhnr")
    public suspend fun saskey(`value`: Output<String>) {
        this.saskey = value
    }

    /**
     * @param value The container in the storage account, only to be specified for WASB storage accounts.
     */
    @JvmName("goftmrbnlquqqogr")
    public suspend fun container(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
     */
    @JvmName("eetfptjyatrtlpde")
    public suspend fun fileSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param value The file share name.
     */
    @JvmName("yvqbomndyavojdbn")
    public suspend fun fileshare(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileshare = mapped
    }

    /**
     * @param value Whether or not the storage account is the default storage account.
     */
    @JvmName("oiileieyaimdapyt")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value The storage account access key.
     */
    @JvmName("nptyjquyprqxefru")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
     */
    @JvmName("kdxullnvmsbjbhpx")
    public suspend fun msiResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msiResourceId = mapped
    }

    /**
     * @param value The name of the storage account.
     */
    @JvmName("nrhddtrmtxbuosqe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
     */
    @JvmName("evdfkjwkyuracpeo")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The shared access signature key.
     */
    @JvmName("ijrvijvxocvrqssx")
    public suspend fun saskey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saskey = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        container = container,
        fileSystem = fileSystem,
        fileshare = fileshare,
        isDefault = isDefault,
        key = key,
        msiResourceId = msiResourceId,
        name = name,
        resourceId = resourceId,
        saskey = saskey,
    )
}
