@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.UserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The User Assigned Identity
 * @property tenantId The tenant id of user assigned identity.
 */
public data class UserAssignedIdentityArgs(
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.UserAssignedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.UserAssignedIdentityArgs =
        com.pulumi.azurenative.hdinsight.inputs.UserAssignedIdentityArgs.builder()
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityArgsBuilder internal constructor() {
    private var tenantId: Output<String>? = null

    /**
     * @param value The tenant id of user assigned identity.
     */
    @JvmName("ntfeqrmsxkrgrxmv")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The tenant id of user assigned identity.
     */
    @JvmName("qltpxrvftxuwyvai")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): UserAssignedIdentityArgs = UserAssignedIdentityArgs(
        tenantId = tenantId,
    )
}
