@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Time and capacity request parameters
 * @property maxInstanceCount The maximum instance count of the cluster
 * @property minInstanceCount The minimum instance count of the cluster
 * @property time 24-hour time in the form xx:xx
 */
public data class AutoscaleTimeAndCapacityResponse(
    public val maxInstanceCount: Int? = null,
    public val minInstanceCount: Int? = null,
    public val time: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.AutoscaleTimeAndCapacityResponse):
            AutoscaleTimeAndCapacityResponse = AutoscaleTimeAndCapacityResponse(
            maxInstanceCount = javaType.maxInstanceCount().map({ args0 -> args0 }).orElse(null),
            minInstanceCount = javaType.minInstanceCount().map({ args0 -> args0 }).orElse(null),
            time = javaType.time().map({ args0 -> args0 }).orElse(null),
        )
    }
}
