@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The information of AAD security group.
 * @property groupId The AAD security group id.
 * @property groupName The AAD security group name.
 */
public data class ClientGroupInfoResponse(
    public val groupId: String? = null,
    public val groupName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ClientGroupInfoResponse):
            ClientGroupInfoResponse = ClientGroupInfoResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
