@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The compute isolation properties.
 * @property enableComputeIsolation The flag indicates whether enable compute isolation or not.
 * @property hostSku The host sku.
 */
public data class ComputeIsolationPropertiesResponse(
    public val enableComputeIsolation: Boolean? = null,
    public val hostSku: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ComputeIsolationPropertiesResponse):
            ComputeIsolationPropertiesResponse = ComputeIsolationPropertiesResponse(
            enableComputeIsolation = javaType.enableComputeIsolation().map({ args0 -> args0 }).orElse(null),
            hostSku = javaType.hostSku().map({ args0 -> args0 }).orElse(null),
        )
    }
}
