@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The data disks groups for the role.
 * @property diskSizeGB ReadOnly. The DiskSize in GB. Do not set this value.
 * @property disksPerNode The number of disks per node.
 * @property storageAccountType ReadOnly. The storage account type. Do not set this value.
 */
public data class DataDisksGroupsResponse(
    public val diskSizeGB: Int,
    public val disksPerNode: Int? = null,
    public val storageAccountType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.DataDisksGroupsResponse):
            DataDisksGroupsResponse = DataDisksGroupsResponse(
            diskSizeGB = javaType.diskSizeGB(),
            disksPerNode = javaType.disksPerNode().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType(),
        )
    }
}
