@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Cluster pool.
 * @property aksClusterProfile Properties of underlying AKS cluster.
 * @property aksManagedResourceGroupName A resource group created by AKS, to hold the infrastructure resources created by AKS on-behalf of customers. It is generated by cluster pool name and managed resource group name by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}
 * @property clusterPoolProfile CLuster pool profile.
 * @property computeProfile CLuster pool compute profile.
 * @property deploymentId A unique id generated by the RP to identify the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property logAnalyticsProfile Cluster pool log analytics profile to enable OMS agent for AKS cluster.
 * @property managedResourceGroupName A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate aksManagedResourceGroupName by pattern: MC_{managedResourceGroupName}_{clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
 * @property name The name of the resource
 * @property networkProfile Cluster pool network profile.
 * @property provisioningState Provisioning state of the resource.
 * @property status Business status of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetClusterPoolResult(
    public val aksClusterProfile: ClusterPoolResourcePropertiesResponseAksClusterProfile,
    public val aksManagedResourceGroupName: String,
    public val clusterPoolProfile: ClusterPoolResourcePropertiesResponseClusterPoolProfile? = null,
    public val computeProfile: ClusterPoolResourcePropertiesResponseComputeProfile,
    public val deploymentId: String,
    public val id: String,
    public val location: String,
    public val logAnalyticsProfile: ClusterPoolResourcePropertiesResponseLogAnalyticsProfile? = null,
    public val managedResourceGroupName: String? = null,
    public val name: String,
    public val networkProfile: ClusterPoolResourcePropertiesResponseNetworkProfile? = null,
    public val provisioningState: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.GetClusterPoolResult):
            GetClusterPoolResult = GetClusterPoolResult(
            aksClusterProfile = javaType.aksClusterProfile().let({ args0 ->
                com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseAksClusterProfile.Companion.toKotlin(args0)
            }),
            aksManagedResourceGroupName = javaType.aksManagedResourceGroupName(),
            clusterPoolProfile = javaType.clusterPoolProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseClusterPoolProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            computeProfile = javaType.computeProfile().let({ args0 ->
                com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseComputeProfile.Companion.toKotlin(args0)
            }),
            deploymentId = javaType.deploymentId(),
            id = javaType.id(),
            location = javaType.location(),
            logAnalyticsProfile = javaType.logAnalyticsProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseLogAnalyticsProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managedResourceGroupName = javaType.managedResourceGroupName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterPoolResourcePropertiesResponseNetworkProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
