@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The virtual network properties.
 * @property id The ID of the virtual network.
 * @property subnet The name of the subnet.
 */
public data class VirtualNetworkProfileResponse(
    public val id: String? = null,
    public val subnet: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.VirtualNetworkProfileResponse):
            VirtualNetworkProfileResponse = VirtualNetworkProfileResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            subnet = javaType.subnet().map({ args0 -> args0 }).orElse(null),
        )
    }
}
