@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthbot.kotlin

import com.pulumi.azurenative.healthbot.kotlin.outputs.HealthBotPropertiesResponse
import com.pulumi.azurenative.healthbot.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.healthbot.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.healthbot.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.healthbot.kotlin.outputs.HealthBotPropertiesResponse.Companion.toKotlin as healthBotPropertiesResponseToKotlin
import com.pulumi.azurenative.healthbot.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.healthbot.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.healthbot.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Bot].
 */
@PulumiTagMarker
public class BotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BotArgs = BotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BotArgsBuilder.() -> Unit) {
        val builder = BotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Bot {
        val builtJavaResource = com.pulumi.azurenative.healthbot.Bot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bot(builtJavaResource)
    }
}

/**
 * Azure Health Bot resource definition
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-12-08.
 * Other available API versions: 2020-12-08-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthbot:Bot samplebotname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthBot/healthBots/{botName}
 * ```
 */
public class Bot internal constructor(
    override val javaResource: com.pulumi.azurenative.healthbot.Bot,
) : KotlinCustomResource(javaResource, BotMapper) {
    /**
     * The identity of the Azure Health Bot.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of properties specific to Azure Health Bot resource.
     */
    public val properties: Output<HealthBotPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                healthBotPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * SKU of the Azure Health Bot.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BotMapper : ResourceMapper<Bot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthbot.Bot::class == javaResource::class

    override fun map(javaResource: Resource): Bot = Bot(
        javaResource as
            com.pulumi.azurenative.healthbot.Bot,
    )
}

/**
 * @see [Bot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bot].
 */
public suspend fun bot(name: String, block: suspend BotResourceBuilder.() -> Unit): Bot {
    val builder = BotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bot(name: String): Bot {
    val builder = BotResourceBuilder()
    builder.name(name)
    return builder.build()
}
