@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.AnalyticsConnectorArgs.builder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.AnalyticsConnectorDataLakeDataDestinationArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.AnalyticsConnectorDataLakeDataDestinationArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.AnalyticsConnectorFhirServiceDataSourceArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.AnalyticsConnectorFhirServiceDataSourceArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.AnalyticsConnectorFhirToParquetMappingArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.AnalyticsConnectorFhirToParquetMappingArgsBuilder
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgs
import com.pulumi.azurenative.healthcareapis.kotlin.inputs.ServiceManagedIdentityIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Analytics Connector definition.
 * Azure REST API version: 2022-10-01-preview.
 * ## Example Usage
 * ### Create or update a Analytics Connectors Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var analyticsConnector = new AzureNative.HealthcareApis.AnalyticsConnector("analyticsConnector", new()
 *     {
 *         AnalyticsConnectorName = "exampleconnector",
 *         DataDestinationConfiguration = new AzureNative.HealthcareApis.Inputs.AnalyticsConnectorDataLakeDataDestinationArgs
 *         {
 *             DataLakeName = "exampledatalake",
 *             Type = "datalake",
 *         },
 *         DataMappingConfiguration = new AzureNative.HealthcareApis.Inputs.AnalyticsConnectorFhirToParquetMappingArgs
 *         {
 *             ExtensionSchemaReference = "acrexample.azurecr.io/blah@sha256aaa/Extension",
 *             FilterConfigurationReference = "acrexample.azurecr.io/blah@sha256xxx",
 *             Type = "fhirToParquet",
 *         },
 *         DataSourceConfiguration = new AzureNative.HealthcareApis.Inputs.AnalyticsConnectorFhirServiceDataSourceArgs
 *         {
 *             Kind = "R4",
 *             Type = "fhirservice",
 *             Url = "https://workspace-examplefhir.fhir.azurehealthcareapis.com",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := healthcareapis.NewAnalyticsConnector(ctx, "analyticsConnector", &healthcareapis.AnalyticsConnectorArgs{
 * AnalyticsConnectorName: pulumi.String("exampleconnector"),
 * DataDestinationConfiguration: interface{}{
 * DataLakeName: pulumi.String("exampledatalake"),
 * Type: pulumi.String("datalake"),
 * },
 * DataMappingConfiguration: interface{}{
 * ExtensionSchemaReference: pulumi.String("acrexample.azurecr.io/blah@sha256aaa/Extension"),
 * FilterConfigurationReference: pulumi.String("acrexample.azurecr.io/blah@sha256xxx"),
 * Type: pulumi.String("fhirToParquet"),
 * },
 * DataSourceConfiguration: interface{}{
 * Kind: pulumi.String("R4"),
 * Type: pulumi.String("fhirservice"),
 * Url: pulumi.String("https://workspace-examplefhir.fhir.azurehealthcareapis.com"),
 * },
 * Location: pulumi.String("westus"),
 * ResourceGroupName: pulumi.String("testRG"),
 * WorkspaceName: pulumi.String("workspace1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.AnalyticsConnector;
 * import com.pulumi.azurenative.healthcareapis.AnalyticsConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var analyticsConnector = new AnalyticsConnector("analyticsConnector", AnalyticsConnectorArgs.builder()
 *             .analyticsConnectorName("exampleconnector")
 *             .dataDestinationConfiguration(Map.ofEntries(
 *                 Map.entry("dataLakeName", "exampledatalake"),
 *                 Map.entry("type", "datalake")
 *             ))
 *             .dataMappingConfiguration(Map.ofEntries(
 *                 Map.entry("extensionSchemaReference", "acrexample.azurecr.io/blah@sha256aaa/Extension"),
 *                 Map.entry("filterConfigurationReference", "acrexample.azurecr.io/blah@sha256xxx"),
 *                 Map.entry("type", "fhirToParquet")
 *             ))
 *             .dataSourceConfiguration(Map.ofEntries(
 *                 Map.entry("kind", "R4"),
 *                 Map.entry("type", "fhirservice"),
 *                 Map.entry("url", "https://workspace-examplefhir.fhir.azurehealthcareapis.com")
 *             ))
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:AnalyticsConnector exampleconnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/analyticsconnectors/{analyticsConnectorName}
 * ```
 * @property analyticsConnectorName The name of Analytics Connector resource.
 * @property dataDestinationConfiguration Data destination configuration for Analytics Connector.
 * @property dataMappingConfiguration Data mapping configuration for Analytics Connector.
 * @property dataSourceConfiguration Data source for Analytics Connector.
 * @property identity Setting indicating whether the service has a managed identity associated with it.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property tags Resource tags.
 * @property workspaceName The name of workspace resource.
 */
public data class AnalyticsConnectorArgs(
    public val analyticsConnectorName: Output<String>? = null,
    public val dataDestinationConfiguration: Output<AnalyticsConnectorDataLakeDataDestinationArgs>? =
        null,
    public val dataMappingConfiguration: Output<AnalyticsConnectorFhirToParquetMappingArgs>? = null,
    public val dataSourceConfiguration: Output<AnalyticsConnectorFhirServiceDataSourceArgs>? = null,
    public val identity: Output<ServiceManagedIdentityIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.AnalyticsConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.AnalyticsConnectorArgs =
        com.pulumi.azurenative.healthcareapis.AnalyticsConnectorArgs.builder()
            .analyticsConnectorName(analyticsConnectorName?.applyValue({ args0 -> args0 }))
            .dataDestinationConfiguration(
                dataDestinationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .dataMappingConfiguration(
                dataMappingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataSourceConfiguration(
                dataSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsConnectorArgs].
 */
@PulumiTagMarker
public class AnalyticsConnectorArgsBuilder internal constructor() {
    private var analyticsConnectorName: Output<String>? = null

    private var dataDestinationConfiguration: Output<AnalyticsConnectorDataLakeDataDestinationArgs>? =
        null

    private var dataMappingConfiguration: Output<AnalyticsConnectorFhirToParquetMappingArgs>? = null

    private var dataSourceConfiguration: Output<AnalyticsConnectorFhirServiceDataSourceArgs>? = null

    private var identity: Output<ServiceManagedIdentityIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of Analytics Connector resource.
     */
    @JvmName("tjxmlwuhwudrhcqx")
    public suspend fun analyticsConnectorName(`value`: Output<String>) {
        this.analyticsConnectorName = value
    }

    /**
     * @param value Data destination configuration for Analytics Connector.
     */
    @JvmName("kekdlkiygegdurls")
    public suspend
    fun dataDestinationConfiguration(`value`: Output<AnalyticsConnectorDataLakeDataDestinationArgs>) {
        this.dataDestinationConfiguration = value
    }

    /**
     * @param value Data mapping configuration for Analytics Connector.
     */
    @JvmName("qwnjukgeocnrpbvi")
    public suspend
    fun dataMappingConfiguration(`value`: Output<AnalyticsConnectorFhirToParquetMappingArgs>) {
        this.dataMappingConfiguration = value
    }

    /**
     * @param value Data source for Analytics Connector.
     */
    @JvmName("bfayfhafaxhlkfyf")
    public suspend
    fun dataSourceConfiguration(`value`: Output<AnalyticsConnectorFhirServiceDataSourceArgs>) {
        this.dataSourceConfiguration = value
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("pqrebofmqfvmacyy")
    public suspend fun identity(`value`: Output<ServiceManagedIdentityIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("srwbyknjnoxhalrk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("oblgbxtjrfopjfxv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yjfqnglblfownfgf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("aifelwyhwlqeelay")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of Analytics Connector resource.
     */
    @JvmName("atdrejgoyqghywuh")
    public suspend fun analyticsConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticsConnectorName = mapped
    }

    /**
     * @param value Data destination configuration for Analytics Connector.
     */
    @JvmName("beqcpckjonycpxev")
    public suspend
    fun dataDestinationConfiguration(`value`: AnalyticsConnectorDataLakeDataDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDestinationConfiguration = mapped
    }

    /**
     * @param argument Data destination configuration for Analytics Connector.
     */
    @JvmName("vhyiqkrhbhqlpqxi")
    public suspend
    fun dataDestinationConfiguration(argument: suspend AnalyticsConnectorDataLakeDataDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConnectorDataLakeDataDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataDestinationConfiguration = mapped
    }

    /**
     * @param value Data mapping configuration for Analytics Connector.
     */
    @JvmName("nxgdpyvdrtusttxr")
    public suspend
    fun dataMappingConfiguration(`value`: AnalyticsConnectorFhirToParquetMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataMappingConfiguration = mapped
    }

    /**
     * @param argument Data mapping configuration for Analytics Connector.
     */
    @JvmName("fyxtqpurpbpywibt")
    public suspend
    fun dataMappingConfiguration(argument: suspend AnalyticsConnectorFhirToParquetMappingArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConnectorFhirToParquetMappingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataMappingConfiguration = mapped
    }

    /**
     * @param value Data source for Analytics Connector.
     */
    @JvmName("omtqripsuejoolhc")
    public suspend
    fun dataSourceConfiguration(`value`: AnalyticsConnectorFhirServiceDataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceConfiguration = mapped
    }

    /**
     * @param argument Data source for Analytics Connector.
     */
    @JvmName("iicoqanffibwdpkp")
    public suspend
    fun dataSourceConfiguration(argument: suspend AnalyticsConnectorFhirServiceDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsConnectorFhirServiceDataSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataSourceConfiguration = mapped
    }

    /**
     * @param value Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("cahoctstiwvrylcq")
    public suspend fun identity(`value`: ServiceManagedIdentityIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Setting indicating whether the service has a managed identity associated with it.
     */
    @JvmName("bgkpsumkctiwpnad")
    public suspend
    fun identity(argument: suspend ServiceManagedIdentityIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceManagedIdentityIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("coydexdjcruasiol")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("usonhicradjrsxaj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yyteiifhajvuspst")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cffgtgejofxygoky")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("yplhowqkhwcyljuk")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): AnalyticsConnectorArgs = AnalyticsConnectorArgs(
        analyticsConnectorName = analyticsConnectorName,
        dataDestinationConfiguration = dataDestinationConfiguration,
        dataMappingConfiguration = dataMappingConfiguration,
        dataSourceConfiguration = dataSourceConfiguration,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
