@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotEventHubIngestionEndpointConfigurationResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotMappingPropertiesResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotEventHubIngestionEndpointConfigurationResponse.Companion.toKotlin as iotEventHubIngestionEndpointConfigurationResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotMappingPropertiesResponse.Companion.toKotlin as iotMappingPropertiesResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.ServiceManagedIdentityResponseIdentity.Companion.toKotlin as serviceManagedIdentityResponseIdentityToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IotConnector].
 */
@PulumiTagMarker
public class IotConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotConnectorArgs = IotConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IotConnectorArgsBuilder.() -> Unit) {
        val builder = IotConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IotConnector {
        val builtJavaResource =
            com.pulumi.azurenative.healthcareapis.IotConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IotConnector(builtJavaResource)
    }
}

/**
 * IoT Connector definition.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01.
 * ## Example Usage
 * ### Create an IoT Connector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotConnector = new AzureNative.HealthcareApis.IotConnector("iotConnector", new()
 *     {
 *         DeviceMapping = new AzureNative.HealthcareApis.Inputs.IotMappingPropertiesArgs
 *         {
 *             Content =
 *             {
 *                 { "template", new[]
 *                 {
 *                     {
 *                         { "template",
 *                         {
 *                             { "deviceIdExpression", "$.deviceid" },
 *                             { "timestampExpression", "$.measurementdatetime" },
 *                             { "typeMatchExpression", "$..[?(@heartrate)]" },
 *                             { "typeName", "heartrate" },
 *                             { "values", new[]
 *                             {
 *                                 {
 *                                     { "required", "true" },
 *                                     { "valueExpression", "$.heartrate" },
 *                                     { "valueName", "hr" },
 *                                 },
 *                             } },
 *                         } },
 *                         { "templateType", "JsonPathContent" },
 *                     },
 *                 } },
 *                 { "templateType", "CollectionContent" },
 *             },
 *         },
 *         Identity = new AzureNative.HealthcareApis.Inputs.ServiceManagedIdentityIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         IngestionEndpointConfiguration = new AzureNative.HealthcareApis.Inputs.IotEventHubIngestionEndpointConfigurationArgs
 *         {
 *             ConsumerGroup = "ConsumerGroupA",
 *             EventHubName = "MyEventHubName",
 *             FullyQualifiedEventHubNamespace = "myeventhub.servicesbus.windows.net",
 *         },
 *         IotConnectorName = "blue",
 *         Location = "westus",
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "additionalProp1", "string" },
 *             { "additionalProp2", "string" },
 *             { "additionalProp3", "string" },
 *         },
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewIotConnector(ctx, "iotConnector", &healthcareapis.IotConnectorArgs{
 * 			DeviceMapping: &healthcareapis.IotMappingPropertiesArgs{
 * 				Content: pulumi.Any{
 * 					Template: []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"template": map[string]interface{}{
 * 								"deviceIdExpression":  "$.deviceid",
 * 								"timestampExpression": "$.measurementdatetime",
 * 								"typeMatchExpression": "$..[?(@heartrate)]",
 * 								"typeName":            "heartrate",
 * 								"values": []map[string]interface{}{
 * 									map[string]interface{}{
 * 										"required":        "true",
 * 										"valueExpression": "$.heartrate",
 * 										"valueName":       "hr",
 * 									},
 * 								},
 * 							},
 * 							"templateType": "JsonPathContent",
 * 						},
 * 					},
 * 					TemplateType: "CollectionContent",
 * 				},
 * 			},
 * 			Identity: &healthcareapis.ServiceManagedIdentityIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			IngestionEndpointConfiguration: &healthcareapis.IotEventHubIngestionEndpointConfigurationArgs{
 * 				ConsumerGroup:                   pulumi.String("ConsumerGroupA"),
 * 				EventHubName:                    pulumi.String("MyEventHubName"),
 * 				FullyQualifiedEventHubNamespace: pulumi.String("myeventhub.servicesbus.windows.net"),
 * 			},
 * 			IotConnectorName:  pulumi.String("blue"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("string"),
 * 				"additionalProp2": pulumi.String("string"),
 * 				"additionalProp3": pulumi.String("string"),
 * 			},
 * 			WorkspaceName: pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.IotConnector;
 * import com.pulumi.azurenative.healthcareapis.IotConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotConnector = new IotConnector("iotConnector", IotConnectorArgs.builder()
 *             .deviceMapping(Map.of("content", Map.ofEntries(
 *                 Map.entry("template", IotMappingPropertiesArgs.builder()
 *                     .template(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .templateType("JsonPathContent")
 *                     .build()),
 *                 Map.entry("templateType", "CollectionContent")
 *             )))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .ingestionEndpointConfiguration(Map.ofEntries(
 *                 Map.entry("consumerGroup", "ConsumerGroupA"),
 *                 Map.entry("eventHubName", "MyEventHubName"),
 *                 Map.entry("fullyQualifiedEventHubNamespace", "myeventhub.servicesbus.windows.net")
 *             ))
 *             .iotConnectorName("blue")
 *             .location("westus")
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("additionalProp1", "string"),
 *                 Map.entry("additionalProp2", "string"),
 *                 Map.entry("additionalProp3", "string")
 *             ))
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:IotConnector blue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/iotconnectors/{iotConnectorName}
 * ```
 */
public class IotConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.healthcareapis.IotConnector,
) : KotlinCustomResource(javaResource, IotConnectorMapper) {
    /**
     * Device Mappings.
     */
    public val deviceMapping: Output<IotMappingPropertiesResponse>?
        get() = javaResource.deviceMapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> iotMappingPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An etag associated with the resource, used for optimistic concurrency when editing it.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Setting indicating whether the service has a managed identity associated with it.
     */
    public val identity: Output<ServiceManagedIdentityResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceManagedIdentityResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Source configuration.
     */
    public val ingestionEndpointConfiguration:
        Output<IotEventHubIngestionEndpointConfigurationResponse>?
        get() = javaResource.ingestionEndpointConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    iotEventHubIngestionEndpointConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotConnectorMapper : ResourceMapper<IotConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.IotConnector::class == javaResource::class

    override fun map(javaResource: Resource): IotConnector = IotConnector(
        javaResource as
            com.pulumi.azurenative.healthcareapis.IotConnector,
    )
}

/**
 * @see [IotConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotConnector].
 */
public suspend fun iotConnector(
    name: String,
    block: suspend IotConnectorResourceBuilder.() -> Unit,
): IotConnector {
    val builder = IotConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotConnector(name: String): IotConnector {
    val builder = IotConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
