@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin

import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WorkspacePrivateEndpointConnection].
 */
@PulumiTagMarker
public class WorkspacePrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspacePrivateEndpointConnectionArgs = WorkspacePrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspacePrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = WorkspacePrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspacePrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.healthcareapis.WorkspacePrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspacePrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2023-02-28. Prior API version in Azure Native 1.x: 2022-05-15.
 * Other available API versions: 2023-09-06, 2023-11-01, 2023-12-01.
 * ## Example Usage
 * ### WorkspacePrivateEndpointConnection_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePrivateEndpointConnection = new AzureNative.HealthcareApis.WorkspacePrivateEndpointConnection("workspacePrivateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "myConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.HealthcareApis.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "testRG",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/healthcareapis/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := healthcareapis.NewWorkspacePrivateEndpointConnection(ctx, "workspacePrivateEndpointConnection", &healthcareapis.WorkspacePrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myConnection"),
 * 			PrivateLinkServiceConnectionState: &healthcareapis.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.healthcareapis.WorkspacePrivateEndpointConnection;
 * import com.pulumi.azurenative.healthcareapis.WorkspacePrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePrivateEndpointConnection = new WorkspacePrivateEndpointConnection("workspacePrivateEndpointConnection", WorkspacePrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("myConnection")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Auto-Approved"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("testRG")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:healthcareapis:WorkspacePrivateEndpointConnection myConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HealthcareApis/workspaces/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class WorkspacePrivateEndpointConnection internal constructor(
    override val javaResource:
    com.pulumi.azurenative.healthcareapis.WorkspacePrivateEndpointConnection,
) : KotlinCustomResource(javaResource, WorkspacePrivateEndpointConnectionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspacePrivateEndpointConnectionMapper :
    ResourceMapper<WorkspacePrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.healthcareapis.WorkspacePrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): WorkspacePrivateEndpointConnection =
        WorkspacePrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.healthcareapis.WorkspacePrivateEndpointConnection,
        )
}

/**
 * @see [WorkspacePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspacePrivateEndpointConnection].
 */
public suspend fun workspacePrivateEndpointConnection(
    name: String,
    block: suspend WorkspacePrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    WorkspacePrivateEndpointConnection {
    val builder = WorkspacePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspacePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspacePrivateEndpointConnection(name: String): WorkspacePrivateEndpointConnection {
    val builder = WorkspacePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
