@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.GetAnalyticsConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property analyticsConnectorName The name of Analytics Connector resource.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property workspaceName The name of workspace resource.
 */
public data class GetAnalyticsConnectorPlainArgs(
    public val analyticsConnectorName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.GetAnalyticsConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.GetAnalyticsConnectorPlainArgs =
        com.pulumi.azurenative.healthcareapis.inputs.GetAnalyticsConnectorPlainArgs.builder()
            .analyticsConnectorName(analyticsConnectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAnalyticsConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetAnalyticsConnectorPlainArgsBuilder internal constructor() {
    private var analyticsConnectorName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of Analytics Connector resource.
     */
    @JvmName("gtxcjelyjoeagyka")
    public suspend fun analyticsConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.analyticsConnectorName = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("dewnveequvxroygb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of workspace resource.
     */
    @JvmName("enthcidumsuefdvg")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetAnalyticsConnectorPlainArgs = GetAnalyticsConnectorPlainArgs(
        analyticsConnectorName = analyticsConnectorName ?: throw
            PulumiNullFieldException("analyticsConnectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
