@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.IotEventHubIngestionEndpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Event Hub ingestion endpoint configuration
 * @property consumerGroup Consumer group of the event hub to connected to.
 * @property eventHubName Event Hub name to connect to.
 * @property fullyQualifiedEventHubNamespace Fully qualified namespace of the Event Hub to connect to.
 */
public data class IotEventHubIngestionEndpointConfigurationArgs(
    public val consumerGroup: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val fullyQualifiedEventHubNamespace: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.IotEventHubIngestionEndpointConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.healthcareapis.inputs.IotEventHubIngestionEndpointConfigurationArgs =
        com.pulumi.azurenative.healthcareapis.inputs.IotEventHubIngestionEndpointConfigurationArgs.builder()
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .fullyQualifiedEventHubNamespace(
                fullyQualifiedEventHubNamespace?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [IotEventHubIngestionEndpointConfigurationArgs].
 */
@PulumiTagMarker
public class IotEventHubIngestionEndpointConfigurationArgsBuilder internal constructor() {
    private var consumerGroup: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var fullyQualifiedEventHubNamespace: Output<String>? = null

    /**
     * @param value Consumer group of the event hub to connected to.
     */
    @JvmName("xcfuiqksatwwiepd")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value Event Hub name to connect to.
     */
    @JvmName("idtpwtkiwnkfkidp")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value Fully qualified namespace of the Event Hub to connect to.
     */
    @JvmName("hokfurkplgkbvwce")
    public suspend fun fullyQualifiedEventHubNamespace(`value`: Output<String>) {
        this.fullyQualifiedEventHubNamespace = value
    }

    /**
     * @param value Consumer group of the event hub to connected to.
     */
    @JvmName("ofxbftqlbwfqrwcl")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value Event Hub name to connect to.
     */
    @JvmName("ewldebgyfkhrpuov")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value Fully qualified namespace of the Event Hub to connect to.
     */
    @JvmName("plgsrelwxytsqius")
    public suspend fun fullyQualifiedEventHubNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullyQualifiedEventHubNamespace = mapped
    }

    internal fun build(): IotEventHubIngestionEndpointConfigurationArgs =
        IotEventHubIngestionEndpointConfigurationArgs(
            consumerGroup = consumerGroup,
            eventHubName = eventHubName,
            fullyQualifiedEventHubNamespace = fullyQualifiedEventHubNamespace,
        )
}
