@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.inputs

import com.pulumi.azurenative.healthcareapis.inputs.IotMappingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The mapping content.
 * @property content The mapping.
 */
public data class IotMappingPropertiesArgs(
    public val content: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.healthcareapis.inputs.IotMappingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.healthcareapis.inputs.IotMappingPropertiesArgs =
        com.pulumi.azurenative.healthcareapis.inputs.IotMappingPropertiesArgs.builder()
            .content(content?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotMappingPropertiesArgs].
 */
@PulumiTagMarker
public class IotMappingPropertiesArgsBuilder internal constructor() {
    private var content: Output<Any>? = null

    /**
     * @param value The mapping.
     */
    @JvmName("fefcmexvlyrwaqgj")
    public suspend fun content(`value`: Output<Any>) {
        this.content = value
    }

    /**
     * @param value The mapping.
     */
    @JvmName("mlekbogfxyyqawxm")
    public suspend fun content(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    internal fun build(): IotMappingPropertiesArgs = IotMappingPropertiesArgs(
        content = content,
    )
}
