@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * FHIR Service data mapping configuration for Analytics Connector.
 * @property extensionSchemaReference Artifact reference for extension schema.
 * @property filterConfigurationReference Artifact reference for filter configurations.
 * @property type Type of data mapping.
 * Expected value is 'fhirToParquet'.
 */
public data class AnalyticsConnectorFhirToParquetMappingResponse(
    public val extensionSchemaReference: String? = null,
    public val filterConfigurationReference: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.AnalyticsConnectorFhirToParquetMappingResponse):
            AnalyticsConnectorFhirToParquetMappingResponse =
            AnalyticsConnectorFhirToParquetMappingResponse(
                extensionSchemaReference = javaType.extensionSchemaReference().map({ args0 -> args0 }).orElse(null),
                filterConfigurationReference = javaType.filterConfigurationReference().map({ args0 ->
                    args0
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
