@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Export operation configuration information
 * @property storageAccountName The name of the default export storage account.
 */
public data class FhirServiceExportConfigurationResponse(
    public val storageAccountName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.FhirServiceExportConfigurationResponse):
            FhirServiceExportConfigurationResponse = FhirServiceExportConfigurationResponse(
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
