@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.healthcareapis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IoT Connector FHIR destination definition.
 * @property etag An etag associated with the resource, used for optimistic concurrency when editing it.
 * @property fhirMapping FHIR Mappings
 * @property fhirServiceResourceId Fully qualified resource id of the FHIR service to connect to.
 * @property id The resource identifier.
 * @property location The resource location.
 * @property name The resource name.
 * @property resourceIdentityResolutionType Determines how resource identity is resolved on the destination.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The resource type.
 */
public data class GetIotConnectorFhirDestinationResult(
    public val etag: String? = null,
    public val fhirMapping: IotMappingPropertiesResponse,
    public val fhirServiceResourceId: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val resourceIdentityResolutionType: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.healthcareapis.outputs.GetIotConnectorFhirDestinationResult):
            GetIotConnectorFhirDestinationResult = GetIotConnectorFhirDestinationResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            fhirMapping = javaType.fhirMapping().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.IotMappingPropertiesResponse.Companion.toKotlin(args0)
            }),
            fhirServiceResourceId = javaType.fhirServiceResourceId(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceIdentityResolutionType = javaType.resourceIdentityResolutionType(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.healthcareapis.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
