@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcloud.kotlin.inputs

import com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudConnectionName The name of the cloud connection resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCloudConnectionPlainArgs(
    public val cloudConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectionPlainArgs =
        com.pulumi.azurenative.hybridcloud.inputs.GetCloudConnectionPlainArgs.builder()
            .cloudConnectionName(cloudConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetCloudConnectionPlainArgsBuilder internal constructor() {
    private var cloudConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cloud connection resource
     */
    @JvmName("vjwpwdypruyvctyl")
    public suspend fun cloudConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fpltmjjwpqapjokf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudConnectionPlainArgs = GetCloudConnectionPlainArgs(
        cloudConnectionName = cloudConnectionName ?: throw PulumiNullFieldException("cloudConnectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
