@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.LicenseArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.enums.LicenseType
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.LicenseDetailsArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.LicenseDetailsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a license in a hybrid machine.
 * Azure REST API version: 2023-06-20-preview.
 * Other available API versions: 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a License
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var license = new AzureNative.HybridCompute.License("license", new()
 *     {
 *         LicenseDetails = new AzureNative.HybridCompute.Inputs.LicenseDetailsArgs
 *         {
 *             Edition = "Datacenter",
 *             Processors = 6,
 *             State = "Activated",
 *             Target = "Windows Server 2012",
 *             Type = "pCore",
 *         },
 *         LicenseName = "{licenseName}",
 *         LicenseType = "ESU",
 *         Location = "eastus2euap",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewLicense(ctx, "license", &hybridcompute.LicenseArgs{
 * 			LicenseDetails: &hybridcompute.LicenseDetailsArgs{
 * 				Edition:    pulumi.String("Datacenter"),
 * 				Processors: pulumi.Int(6),
 * 				State:      pulumi.String("Activated"),
 * 				Target:     pulumi.String("Windows Server 2012"),
 * 				Type:       pulumi.String("pCore"),
 * 			},
 * 			LicenseName:       pulumi.String("{licenseName}"),
 * 			LicenseType:       pulumi.String("ESU"),
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.License;
 * import com.pulumi.azurenative.hybridcompute.LicenseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var license = new License("license", LicenseArgs.builder()
 *             .licenseDetails(Map.ofEntries(
 *                 Map.entry("edition", "Datacenter"),
 *                 Map.entry("processors", 6),
 *                 Map.entry("state", "Activated"),
 *                 Map.entry("target", "Windows Server 2012"),
 *                 Map.entry("type", "pCore")
 *             ))
 *             .licenseName("{licenseName}")
 *             .licenseType("ESU")
 *             .location("eastus2euap")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:License {licenseName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}
 * ```
 * @property licenseDetails Describes the properties of a License.
 * @property licenseName The name of the license.
 * @property licenseType The type of the license resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property tenantId Describes the tenant id.
 */
public data class LicenseArgs(
    public val licenseDetails: Output<LicenseDetailsArgs>? = null,
    public val licenseName: Output<String>? = null,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.LicenseArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.LicenseArgs =
        com.pulumi.azurenative.hybridcompute.LicenseArgs.builder()
            .licenseDetails(licenseDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .licenseName(licenseName?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LicenseArgs].
 */
@PulumiTagMarker
public class LicenseArgsBuilder internal constructor() {
    private var licenseDetails: Output<LicenseDetailsArgs>? = null

    private var licenseName: Output<String>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Describes the properties of a License.
     */
    @JvmName("imvqmybmsnxsklsg")
    public suspend fun licenseDetails(`value`: Output<LicenseDetailsArgs>) {
        this.licenseDetails = value
    }

    /**
     * @param value The name of the license.
     */
    @JvmName("yykestfdvtpjpwfe")
    public suspend fun licenseName(`value`: Output<String>) {
        this.licenseName = value
    }

    /**
     * @param value The type of the license resource.
     */
    @JvmName("fettnqdnstmabjej")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nfwnnrejjbrcjwms")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hskngpmcmtolujso")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ydgpvlpfsmvflmnk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Describes the tenant id.
     */
    @JvmName("dbyawrnkfiojwtlu")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Describes the properties of a License.
     */
    @JvmName("aovtoinrsrwievac")
    public suspend fun licenseDetails(`value`: LicenseDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseDetails = mapped
    }

    /**
     * @param argument Describes the properties of a License.
     */
    @JvmName("hdhtccwkqerwgjbh")
    public suspend fun licenseDetails(argument: suspend LicenseDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = LicenseDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.licenseDetails = mapped
    }

    /**
     * @param value The name of the license.
     */
    @JvmName("ktschbasykgikyks")
    public suspend fun licenseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseName = mapped
    }

    /**
     * @param value The type of the license resource.
     */
    @JvmName("hnosayxvjndpitly")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The type of the license resource.
     */
    @JvmName("mujfenorkgqeocqe")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The type of the license resource.
     */
    @JvmName("wwhssrahpjyevbee")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hvbhsdqquhvjdefn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gidawcaxagxikupr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("llcmbmgkmaojiuee")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dshyqapuflcdvsri")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Describes the tenant id.
     */
    @JvmName("lnakdvvlhtqvnehs")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): LicenseArgs = LicenseArgs(
        licenseDetails = licenseDetails,
        licenseName = licenseName,
        licenseType = licenseType,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        tenantId = tenantId,
    )
}
