@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.MachineArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.AgentUpgradeArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.AgentUpgradeArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.LocationDataArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.LocationDataArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.MachineExtensionInstanceViewArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.MachineExtensionInstanceViewArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.OSProfileArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.OSProfileArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.ServiceStatusesArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.ServiceStatusesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a hybrid machine.
 * Azure REST API version: 2022-12-27. Prior API version in Azure Native 1.x: 2020-08-02.
 * Other available API versions: 2019-03-18-preview, 2019-08-02-preview, 2020-08-02, 2020-08-15-preview, 2022-05-10-preview, 2023-06-20-preview, 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a Machine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machine = new AzureNative.HybridCompute.Machine("machine", new()
 *     {
 *         ClientPublicKey = "string",
 *         Identity = new AzureNative.HybridCompute.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.HybridCompute.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2euap",
 *         LocationData = new AzureNative.HybridCompute.Inputs.LocationDataArgs
 *         {
 *             Name = "Redmond",
 *         },
 *         MachineName = "myMachine",
 *         ParentClusterResourceId = "{AzureStackHCIResourceId}",
 *         PrivateLinkScopeResourceId = "/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName",
 *         ResourceGroupName = "myResourceGroup",
 *         VmId = "b7a098cc-b0b8-46e8-a205-62f301a62a8f",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewMachine(ctx, "machine", &hybridcompute.MachineArgs{
 * 			ClientPublicKey: pulumi.String("string"),
 * 			Identity: &hybridcompute.IdentityArgs{
 * 				Type: hybridcompute.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location: pulumi.String("eastus2euap"),
 * 			LocationData: &hybridcompute.LocationDataArgs{
 * 				Name: pulumi.String("Redmond"),
 * 			},
 * 			MachineName:                pulumi.String("myMachine"),
 * 			ParentClusterResourceId:    pulumi.String("{AzureStackHCIResourceId}"),
 * 			PrivateLinkScopeResourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			VmId:                       pulumi.String("b7a098cc-b0b8-46e8-a205-62f301a62a8f"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.Machine;
 * import com.pulumi.azurenative.hybridcompute.MachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machine = new Machine("machine", MachineArgs.builder()
 *             .clientPublicKey("string")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus2euap")
 *             .locationData(Map.of("name", "Redmond"))
 *             .machineName("myMachine")
 *             .parentClusterResourceId("{AzureStackHCIResourceId}")
 *             .privateLinkScopeResourceId("/subscriptions/{subscriptionId}/resourceGroups/myResourceGroup/providers/Microsoft.HybridCompute/privateLinkScopes/privateLinkScopeName")
 *             .resourceGroupName("myResourceGroup")
 *             .vmId("b7a098cc-b0b8-46e8-a205-62f301a62a8f")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:Machine myMachine /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}
 * ```
 * @property agentUpgrade The info of the machine w.r.t Agent Upgrade
 * @property clientPublicKey Public Key that the client provides to be used during initial resource onboarding
 * @property extensions Machine Extensions information (deprecated field)
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property locationData Metadata pertaining to the geographic location of the resource.
 * @property machineName The name of the hybrid machine.
 * @property mssqlDiscovered Specifies whether any MS SQL instance is discovered on the machine.
 * @property osProfile Specifies the operating system settings for the hybrid machine.
 * @property osType The type of Operating System (windows/linux).
 * @property parentClusterResourceId The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
 * @property privateLinkScopeResourceId The resource id of the private link scope this machine is assigned to, if any.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceStatuses Statuses of dependent services that are reported back to ARM.
 * @property tags Resource tags.
 * @property vmId Specifies the hybrid machine unique ID.
 */
public data class MachineArgs(
    public val agentUpgrade: Output<AgentUpgradeArgs>? = null,
    public val clientPublicKey: Output<String>? = null,
    public val extensions: Output<List<MachineExtensionInstanceViewArgs>>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val locationData: Output<LocationDataArgs>? = null,
    public val machineName: Output<String>? = null,
    public val mssqlDiscovered: Output<String>? = null,
    public val osProfile: Output<OSProfileArgs>? = null,
    public val osType: Output<String>? = null,
    public val parentClusterResourceId: Output<String>? = null,
    public val privateLinkScopeResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceStatuses: Output<ServiceStatusesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.MachineArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.MachineArgs =
        com.pulumi.azurenative.hybridcompute.MachineArgs.builder()
            .agentUpgrade(agentUpgrade?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clientPublicKey(clientPublicKey?.applyValue({ args0 -> args0 }))
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .locationData(locationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .mssqlDiscovered(mssqlDiscovered?.applyValue({ args0 -> args0 }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osType(osType?.applyValue({ args0 -> args0 }))
            .parentClusterResourceId(parentClusterResourceId?.applyValue({ args0 -> args0 }))
            .privateLinkScopeResourceId(privateLinkScopeResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceStatuses(serviceStatuses?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmId(vmId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineArgs].
 */
@PulumiTagMarker
public class MachineArgsBuilder internal constructor() {
    private var agentUpgrade: Output<AgentUpgradeArgs>? = null

    private var clientPublicKey: Output<String>? = null

    private var extensions: Output<List<MachineExtensionInstanceViewArgs>>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var locationData: Output<LocationDataArgs>? = null

    private var machineName: Output<String>? = null

    private var mssqlDiscovered: Output<String>? = null

    private var osProfile: Output<OSProfileArgs>? = null

    private var osType: Output<String>? = null

    private var parentClusterResourceId: Output<String>? = null

    private var privateLinkScopeResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceStatuses: Output<ServiceStatusesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmId: Output<String>? = null

    /**
     * @param value The info of the machine w.r.t Agent Upgrade
     */
    @JvmName("beeskgfhjdckuynu")
    public suspend fun agentUpgrade(`value`: Output<AgentUpgradeArgs>) {
        this.agentUpgrade = value
    }

    /**
     * @param value Public Key that the client provides to be used during initial resource onboarding
     */
    @JvmName("audltccnieowiafp")
    public suspend fun clientPublicKey(`value`: Output<String>) {
        this.clientPublicKey = value
    }

    /**
     * @param value Machine Extensions information (deprecated field)
     */
    @JvmName("gnxyityonsdmpvla")
    public suspend fun extensions(`value`: Output<List<MachineExtensionInstanceViewArgs>>) {
        this.extensions = value
    }

    @JvmName("phoycxotdnboddng")
    public suspend fun extensions(vararg values: Output<MachineExtensionInstanceViewArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values Machine Extensions information (deprecated field)
     */
    @JvmName("mnntldaifeddidso")
    public suspend fun extensions(values: List<Output<MachineExtensionInstanceViewArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("ppomekaxoxmktbtk")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lpgmiiiatiuouwif")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Metadata pertaining to the geographic location of the resource.
     */
    @JvmName("vwdgayjsdpasruqx")
    public suspend fun locationData(`value`: Output<LocationDataArgs>) {
        this.locationData = value
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("mvkaeardmedmqoaa")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value Specifies whether any MS SQL instance is discovered on the machine.
     */
    @JvmName("eqgdfdajfucouiyq")
    public suspend fun mssqlDiscovered(`value`: Output<String>) {
        this.mssqlDiscovered = value
    }

    /**
     * @param value Specifies the operating system settings for the hybrid machine.
     */
    @JvmName("ypdxdtcejhwppwry")
    public suspend fun osProfile(`value`: Output<OSProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The type of Operating System (windows/linux).
     */
    @JvmName("seftcssyimcecxva")
    public suspend fun osType(`value`: Output<String>) {
        this.osType = value
    }

    /**
     * @param value The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
     */
    @JvmName("chdqdelybvuygedw")
    public suspend fun parentClusterResourceId(`value`: Output<String>) {
        this.parentClusterResourceId = value
    }

    /**
     * @param value The resource id of the private link scope this machine is assigned to, if any.
     */
    @JvmName("quvgbagjpunyplfw")
    public suspend fun privateLinkScopeResourceId(`value`: Output<String>) {
        this.privateLinkScopeResourceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("exefqhiijnneocjh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Statuses of dependent services that are reported back to ARM.
     */
    @JvmName("lhhffbdrmnohfvwk")
    public suspend fun serviceStatuses(`value`: Output<ServiceStatusesArgs>) {
        this.serviceStatuses = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("idhgwhsexsawmmga")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the hybrid machine unique ID.
     */
    @JvmName("twwwmdstbnsguymm")
    public suspend fun vmId(`value`: Output<String>) {
        this.vmId = value
    }

    /**
     * @param value The info of the machine w.r.t Agent Upgrade
     */
    @JvmName("jeucwshbualavcln")
    public suspend fun agentUpgrade(`value`: AgentUpgradeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentUpgrade = mapped
    }

    /**
     * @param argument The info of the machine w.r.t Agent Upgrade
     */
    @JvmName("qjadwhifowuwryhe")
    public suspend fun agentUpgrade(argument: suspend AgentUpgradeArgsBuilder.() -> Unit) {
        val toBeMapped = AgentUpgradeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentUpgrade = mapped
    }

    /**
     * @param value Public Key that the client provides to be used during initial resource onboarding
     */
    @JvmName("kcvgmaoqlogvjxyv")
    public suspend fun clientPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientPublicKey = mapped
    }

    /**
     * @param value Machine Extensions information (deprecated field)
     */
    @JvmName("hejvorwftdbveerj")
    public suspend fun extensions(`value`: List<MachineExtensionInstanceViewArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument Machine Extensions information (deprecated field)
     */
    @JvmName("huvtugttwaylujad")
    public suspend
    fun extensions(argument: List<suspend MachineExtensionInstanceViewArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MachineExtensionInstanceViewArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument Machine Extensions information (deprecated field)
     */
    @JvmName("atqjwosrxrldvoim")
    public suspend fun extensions(
        vararg
        argument: suspend MachineExtensionInstanceViewArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MachineExtensionInstanceViewArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument Machine Extensions information (deprecated field)
     */
    @JvmName("mlrxdovtpshccckc")
    public suspend
    fun extensions(argument: suspend MachineExtensionInstanceViewArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MachineExtensionInstanceViewArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values Machine Extensions information (deprecated field)
     */
    @JvmName("kcvhoubcilmjrcea")
    public suspend fun extensions(vararg values: MachineExtensionInstanceViewArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("uxdxjvirgmfiaykx")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("ovdxmvudlwqwkwsc")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sqtsbqvamqctmwmp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Metadata pertaining to the geographic location of the resource.
     */
    @JvmName("mukltfqonpgrpslu")
    public suspend fun locationData(`value`: LocationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationData = mapped
    }

    /**
     * @param argument Metadata pertaining to the geographic location of the resource.
     */
    @JvmName("mvsudjhgvxbqfjlg")
    public suspend fun locationData(argument: suspend LocationDataArgsBuilder.() -> Unit) {
        val toBeMapped = LocationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.locationData = mapped
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("mtoloiakpxholigt")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value Specifies whether any MS SQL instance is discovered on the machine.
     */
    @JvmName("njcvvnaodgficold")
    public suspend fun mssqlDiscovered(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mssqlDiscovered = mapped
    }

    /**
     * @param value Specifies the operating system settings for the hybrid machine.
     */
    @JvmName("abfbgaosvqedwbqc")
    public suspend fun osProfile(`value`: OSProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument Specifies the operating system settings for the hybrid machine.
     */
    @JvmName("amuqwyuoqohnxesy")
    public suspend fun osProfile(argument: suspend OSProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OSProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The type of Operating System (windows/linux).
     */
    @JvmName("swgjoiuciuawxdiv")
    public suspend fun osType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
     */
    @JvmName("owwpowvudbkcrnwo")
    public suspend fun parentClusterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentClusterResourceId = mapped
    }

    /**
     * @param value The resource id of the private link scope this machine is assigned to, if any.
     */
    @JvmName("fxswbpwdfchbsbxb")
    public suspend fun privateLinkScopeResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkScopeResourceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ummggmhbqdroifkl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Statuses of dependent services that are reported back to ARM.
     */
    @JvmName("cosbxrmvxsyhmcec")
    public suspend fun serviceStatuses(`value`: ServiceStatusesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceStatuses = mapped
    }

    /**
     * @param argument Statuses of dependent services that are reported back to ARM.
     */
    @JvmName("oakhwomsnxiwjapv")
    public suspend fun serviceStatuses(argument: suspend ServiceStatusesArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceStatusesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceStatuses = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gogtjwpdbnqbilvp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("imcoikyxikmnftaj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the hybrid machine unique ID.
     */
    @JvmName("uudsmjrgqjsntfuo")
    public suspend fun vmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmId = mapped
    }

    internal fun build(): MachineArgs = MachineArgs(
        agentUpgrade = agentUpgrade,
        clientPublicKey = clientPublicKey,
        extensions = extensions,
        identity = identity,
        location = location,
        locationData = locationData,
        machineName = machineName,
        mssqlDiscovered = mssqlDiscovered,
        osProfile = osProfile,
        osType = osType,
        parentClusterResourceId = parentClusterResourceId,
        privateLinkScopeResourceId = privateLinkScopeResourceId,
        resourceGroupName = resourceGroupName,
        serviceStatuses = serviceStatuses,
        tags = tags,
        vmId = vmId,
    )
}
