@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.MachineRunCommandArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.MachineRunCommandScriptSourceArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.MachineRunCommandScriptSourceArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.RunCommandInputParameterArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.RunCommandInputParameterArgsBuilder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.RunCommandManagedIdentityArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.RunCommandManagedIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Run Command
 * Azure REST API version: 2023-10-03-preview.
 * ## Example Usage
 * ### Create or Update a Run Command
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineRunCommand = new AzureNative.HybridCompute.MachineRunCommand("machineRunCommand", new()
 *     {
 *         AsyncExecution = false,
 *         ErrorBlobUri = "https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt",
 *         Location = "eastus2",
 *         MachineName = "myMachine",
 *         OutputBlobUri = "https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt",
 *         Parameters = new[]
 *         {
 *             new AzureNative.HybridCompute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param1",
 *                 Value = "value1",
 *             },
 *             new AzureNative.HybridCompute.Inputs.RunCommandInputParameterArgs
 *             {
 *                 Name = "param2",
 *                 Value = "value2",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         RunAsPassword = "<runAsPassword>",
 *         RunAsUser = "user1",
 *         RunCommandName = "myRunCommand",
 *         Source = new AzureNative.HybridCompute.Inputs.MachineRunCommandScriptSourceArgs
 *         {
 *             Script = "Write-Host Hello World!",
 *         },
 *         TimeoutInSeconds = 3600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewMachineRunCommand(ctx, "machineRunCommand", &hybridcompute.MachineRunCommandArgs{
 * 			AsyncExecution: pulumi.Bool(false),
 * 			ErrorBlobUri:   pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt"),
 * 			Location:       pulumi.String("eastus2"),
 * 			MachineName:    pulumi.String("myMachine"),
 * 			OutputBlobUri:  pulumi.String("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt"),
 * 			Parameters: []hybridcompute.RunCommandInputParameterArgs{
 * 				{
 * 					Name:  pulumi.String("param1"),
 * 					Value: pulumi.String("value1"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("param2"),
 * 					Value: pulumi.String("value2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunAsPassword:     pulumi.String("<runAsPassword>"),
 * 			RunAsUser:         pulumi.String("user1"),
 * 			RunCommandName:    pulumi.String("myRunCommand"),
 * 			Source: &hybridcompute.MachineRunCommandScriptSourceArgs{
 * 				Script: pulumi.String("Write-Host Hello World!"),
 * 			},
 * 			TimeoutInSeconds: pulumi.Int(3600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.MachineRunCommand;
 * import com.pulumi.azurenative.hybridcompute.MachineRunCommandArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineRunCommand = new MachineRunCommand("machineRunCommand", MachineRunCommandArgs.builder()
 *             .asyncExecution(false)
 *             .errorBlobUri("https://mystorageaccount.blob.core.windows.net/mycontainer/MyScriptError.txt")
 *             .location("eastus2")
 *             .machineName("myMachine")
 *             .outputBlobUri("https://mystorageaccount.blob.core.windows.net/myscriptoutputcontainer/MyScriptoutput.txt")
 *             .parameters(
 *                 Map.ofEntries(
 *                     Map.entry("name", "param1"),
 *                     Map.entry("value", "value1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "param2"),
 *                     Map.entry("value", "value2")
 *                 ))
 *             .resourceGroupName("myResourceGroup")
 *             .runAsPassword("<runAsPassword>")
 *             .runAsUser("user1")
 *             .runCommandName("myRunCommand")
 *             .source(Map.of("script", "Write-Host Hello World!"))
 *             .timeoutInSeconds(3600)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:MachineRunCommand myRunCommand /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/runCommands/{runCommandName}
 * ```
 * @property asyncExecution Optional. If set to true, provisioning will complete as soon as script starts and will not wait for script to complete.
 * @property errorBlobManagedIdentity User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
 * @property errorBlobUri Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
 * @property location The geo-location where the resource lives
 * @property machineName The name of the hybrid machine.
 * @property outputBlobManagedIdentity User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
 * @property outputBlobUri Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
 * @property parameters The parameters used by the script.
 * @property protectedParameters The parameters used by the script.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property runAsPassword Specifies the user account password on the machine when executing the run command.
 * @property runAsUser Specifies the user account on the machine when executing the run command.
 * @property runCommandName The name of the run command.
 * @property source The source of the run command script.
 * @property tags Resource tags.
 * @property timeoutInSeconds The timeout in seconds to execute the run command.
 */
public data class MachineRunCommandArgs(
    public val asyncExecution: Output<Boolean>? = null,
    public val errorBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
    public val errorBlobUri: Output<String>? = null,
    public val location: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val outputBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null,
    public val outputBlobUri: Output<String>? = null,
    public val parameters: Output<List<RunCommandInputParameterArgs>>? = null,
    public val protectedParameters: Output<List<RunCommandInputParameterArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runAsPassword: Output<String>? = null,
    public val runAsUser: Output<String>? = null,
    public val runCommandName: Output<String>? = null,
    public val source: Output<MachineRunCommandScriptSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.MachineRunCommandArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.MachineRunCommandArgs =
        com.pulumi.azurenative.hybridcompute.MachineRunCommandArgs.builder()
            .asyncExecution(asyncExecution?.applyValue({ args0 -> args0 }))
            .errorBlobManagedIdentity(
                errorBlobManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .errorBlobUri(errorBlobUri?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .outputBlobManagedIdentity(
                outputBlobManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputBlobUri(outputBlobUri?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protectedParameters(
                protectedParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runAsPassword(runAsPassword?.applyValue({ args0 -> args0 }))
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 }))
            .runCommandName(runCommandName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineRunCommandArgs].
 */
@PulumiTagMarker
public class MachineRunCommandArgsBuilder internal constructor() {
    private var asyncExecution: Output<Boolean>? = null

    private var errorBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    private var errorBlobUri: Output<String>? = null

    private var location: Output<String>? = null

    private var machineName: Output<String>? = null

    private var outputBlobManagedIdentity: Output<RunCommandManagedIdentityArgs>? = null

    private var outputBlobUri: Output<String>? = null

    private var parameters: Output<List<RunCommandInputParameterArgs>>? = null

    private var protectedParameters: Output<List<RunCommandInputParameterArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runAsPassword: Output<String>? = null

    private var runAsUser: Output<String>? = null

    private var runCommandName: Output<String>? = null

    private var source: Output<MachineRunCommandScriptSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeoutInSeconds: Output<Int>? = null

    /**
     * @param value Optional. If set to true, provisioning will complete as soon as script starts and will not wait for script to complete.
     */
    @JvmName("xlywamtinjmioykd")
    public suspend fun asyncExecution(`value`: Output<Boolean>) {
        this.asyncExecution = value
    }

    /**
     * @param value User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("vvisvkyhymrwvxij")
    public suspend fun errorBlobManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.errorBlobManagedIdentity = value
    }

    /**
     * @param value Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    @JvmName("efsmrvufbclchliq")
    public suspend fun errorBlobUri(`value`: Output<String>) {
        this.errorBlobUri = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ouyiperfbddtdlog")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("stbchkfkblhwyucv")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("yndqpdyygdwxvjan")
    public suspend fun outputBlobManagedIdentity(`value`: Output<RunCommandManagedIdentityArgs>) {
        this.outputBlobManagedIdentity = value
    }

    /**
     * @param value Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    @JvmName("natuidopplucynax")
    public suspend fun outputBlobUri(`value`: Output<String>) {
        this.outputBlobUri = value
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("egsmtolqydycxjxb")
    public suspend fun parameters(`value`: Output<List<RunCommandInputParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("dwckvgpivjbnpwov")
    public suspend fun parameters(vararg values: Output<RunCommandInputParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("ekfwwudnogstluyj")
    public suspend fun parameters(values: List<Output<RunCommandInputParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("ccnffkrxuvokpmxw")
    public suspend fun protectedParameters(`value`: Output<List<RunCommandInputParameterArgs>>) {
        this.protectedParameters = value
    }

    @JvmName("olorxrqkpbwejheg")
    public suspend fun protectedParameters(vararg values: Output<RunCommandInputParameterArgs>) {
        this.protectedParameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("xfwrggadxknvbpth")
    public suspend fun protectedParameters(values: List<Output<RunCommandInputParameterArgs>>) {
        this.protectedParameters = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrtjxuncnrnvyusm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the user account password on the machine when executing the run command.
     */
    @JvmName("eeocsyyepyqpmutc")
    public suspend fun runAsPassword(`value`: Output<String>) {
        this.runAsPassword = value
    }

    /**
     * @param value Specifies the user account on the machine when executing the run command.
     */
    @JvmName("fkujcwwrxgosofrh")
    public suspend fun runAsUser(`value`: Output<String>) {
        this.runAsUser = value
    }

    /**
     * @param value The name of the run command.
     */
    @JvmName("mvvigrpntorxpbpi")
    public suspend fun runCommandName(`value`: Output<String>) {
        this.runCommandName = value
    }

    /**
     * @param value The source of the run command script.
     */
    @JvmName("levblygqnoycfvhp")
    public suspend fun source(`value`: Output<MachineRunCommandScriptSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fhvhsgunagjwkuxp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The timeout in seconds to execute the run command.
     */
    @JvmName("ulxivnwlkjwgjnel")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Optional. If set to true, provisioning will complete as soon as script starts and will not wait for script to complete.
     */
    @JvmName("eihvqaspjfmvjved")
    public suspend fun asyncExecution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asyncExecution = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("fbbsjbqmqjtsyora")
    public suspend fun errorBlobManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorBlobManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to errorBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("hgkemryvpnlnwiwn")
    public suspend
    fun errorBlobManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.errorBlobManagedIdentity = mapped
    }

    /**
     * @param value Specifies the Azure storage blob where script error stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer errorBlobManagedIdentity parameter.
     */
    @JvmName("mjdmdrdbgcdksrhj")
    public suspend fun errorBlobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorBlobUri = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yhugwghcjrsgvqan")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the hybrid machine.
     */
    @JvmName("bdkeiyplnsmltexg")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("tywooopihwahvpby")
    public suspend fun outputBlobManagedIdentity(`value`: RunCommandManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBlobManagedIdentity = mapped
    }

    /**
     * @param argument User-assigned managed identity that has access to outputBlobUri storage blob. Use an empty object in case of system-assigned identity. Make sure managed identity has been given access to blob's container with 'Storage Blob Data Contributor' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged
     */
    @JvmName("fyquwatfseruavji")
    public suspend
    fun outputBlobManagedIdentity(argument: suspend RunCommandManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = RunCommandManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputBlobManagedIdentity = mapped
    }

    /**
     * @param value Specifies the Azure storage blob where script output stream will be uploaded. Use a SAS URI with read, append, create, write access OR use managed identity to provide the VM access to the blob. Refer outputBlobManagedIdentity parameter.
     */
    @JvmName("iaotdmvtwflpruxa")
    public suspend fun outputBlobUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputBlobUri = mapped
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("wegidsdhdgljpmlj")
    public suspend fun parameters(`value`: List<RunCommandInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("vrxsctafeihrecly")
    public suspend
    fun parameters(argument: List<suspend RunCommandInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("cbgfpmqsnukadfgu")
    public suspend fun parameters(
        vararg
        argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("rcphjmxwempakfsx")
    public suspend fun parameters(argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RunCommandInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("ffaufpplwvawnwoy")
    public suspend fun parameters(vararg values: RunCommandInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The parameters used by the script.
     */
    @JvmName("fpkdcjyyqnawttvc")
    public suspend fun protectedParameters(`value`: List<RunCommandInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("vufqwbohrjdotuli")
    public suspend
    fun protectedParameters(argument: List<suspend RunCommandInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("jvyhubunugtwckqn")
    public suspend fun protectedParameters(
        vararg
        argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RunCommandInputParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param argument The parameters used by the script.
     */
    @JvmName("lhxuofnbguspusca")
    public suspend
    fun protectedParameters(argument: suspend RunCommandInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RunCommandInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protectedParameters = mapped
    }

    /**
     * @param values The parameters used by the script.
     */
    @JvmName("eiuncumfilxkopvd")
    public suspend fun protectedParameters(vararg values: RunCommandInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedParameters = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ooooljqmqafmanni")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the user account password on the machine when executing the run command.
     */
    @JvmName("kkwaqyjuhxtqvilg")
    public suspend fun runAsPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsPassword = mapped
    }

    /**
     * @param value Specifies the user account on the machine when executing the run command.
     */
    @JvmName("ctoujatcqdoensmt")
    public suspend fun runAsUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    /**
     * @param value The name of the run command.
     */
    @JvmName("ucfeyaiveucunbva")
    public suspend fun runCommandName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runCommandName = mapped
    }

    /**
     * @param value The source of the run command script.
     */
    @JvmName("sydujotghxswvhaq")
    public suspend fun source(`value`: MachineRunCommandScriptSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source of the run command script.
     */
    @JvmName("giqapwhsmeixblmd")
    public suspend fun source(argument: suspend MachineRunCommandScriptSourceArgsBuilder.() -> Unit) {
        val toBeMapped = MachineRunCommandScriptSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jnxdotwsacrlkoja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gxjsnolnubpeqglu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The timeout in seconds to execute the run command.
     */
    @JvmName("kyuhiwnnupfbqruj")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    internal fun build(): MachineRunCommandArgs = MachineRunCommandArgs(
        asyncExecution = asyncExecution,
        errorBlobManagedIdentity = errorBlobManagedIdentity,
        errorBlobUri = errorBlobUri,
        location = location,
        machineName = machineName,
        outputBlobManagedIdentity = outputBlobManagedIdentity,
        outputBlobUri = outputBlobUri,
        parameters = parameters,
        protectedParameters = protectedParameters,
        resourceGroupName = resourceGroupName,
        runAsPassword = runAsPassword,
        runAsUser = runAsUser,
        runCommandName = runCommandName,
        source = source,
        tags = tags,
        timeoutInSeconds = timeoutInSeconds,
    )
}
