@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.kotlin.outputs.HybridComputePrivateLinkScopePropertiesResponse
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.HybridComputePrivateLinkScopePropertiesResponse.Companion.toKotlin as hybridComputePrivateLinkScopePropertiesResponseToKotlin
import com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateLinkScope].
 */
@PulumiTagMarker
public class PrivateLinkScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkScopeArgs = PrivateLinkScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkScopeArgsBuilder.() -> Unit) {
        val builder = PrivateLinkScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateLinkScope {
        val builtJavaResource =
            com.pulumi.azurenative.hybridcompute.PrivateLinkScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkScope(builtJavaResource)
    }
}

/**
 * An Azure Arc PrivateLinkScope definition.
 * Azure REST API version: 2022-12-27. Prior API version in Azure Native 1.x: 2021-03-25-preview.
 * Other available API versions: 2020-08-15-preview, 2023-06-20-preview, 2023-10-03-preview.
 * ## Example Usage
 * ### PrivateLinkScopeCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.HybridCompute.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewPrivateLinkScope(ctx, "privateLinkScope", &hybridcompute.PrivateLinkScopeArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScope;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateLinkScopeUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.HybridCompute.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewPrivateLinkScope(ctx, "privateLinkScope", &hybridcompute.PrivateLinkScopeArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScope;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:PrivateLinkScope my-privatelinkscope /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/privateLinkScopes/{scopeName}
 * ```
 */
public class PrivateLinkScope internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridcompute.PrivateLinkScope,
) : KotlinCustomResource(javaResource, PrivateLinkScopeMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties that define a Azure Arc PrivateLinkScope resource.
     */
    public val properties: Output<HybridComputePrivateLinkScopePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                hybridComputePrivateLinkScopePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkScopeMapper : ResourceMapper<PrivateLinkScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridcompute.PrivateLinkScope::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkScope = PrivateLinkScope(
        javaResource as
            com.pulumi.azurenative.hybridcompute.PrivateLinkScope,
    )
}

/**
 * @see [PrivateLinkScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkScope].
 */
public suspend fun privateLinkScope(
    name: String,
    block: suspend PrivateLinkScopeResourceBuilder.() -> Unit,
): PrivateLinkScope {
    val builder = PrivateLinkScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkScope(name: String): PrivateLinkScope {
    val builder = PrivateLinkScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
