@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin

import com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.HybridComputePrivateLinkScopePropertiesArgs
import com.pulumi.azurenative.hybridcompute.kotlin.inputs.HybridComputePrivateLinkScopePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Arc PrivateLinkScope definition.
 * Azure REST API version: 2022-12-27. Prior API version in Azure Native 1.x: 2021-03-25-preview.
 * Other available API versions: 2020-08-15-preview, 2023-06-20-preview, 2023-10-03-preview.
 * ## Example Usage
 * ### PrivateLinkScopeCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.HybridCompute.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewPrivateLinkScope(ctx, "privateLinkScope", &hybridcompute.PrivateLinkScopeArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScope;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateLinkScopeUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.HybridCompute.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridcompute.NewPrivateLinkScope(ctx, "privateLinkScope", &hybridcompute.PrivateLinkScopeArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScope;
 * import com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridcompute:PrivateLinkScope my-privatelinkscope /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/privateLinkScopes/{scopeName}
 * ```
 * @property location Resource location
 * @property properties Properties that define a Azure Arc PrivateLinkScope resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Arc PrivateLinkScope resource.
 * @property tags Resource tags
 */
public data class PrivateLinkScopeArgs(
    public val location: Output<String>? = null,
    public val properties: Output<HybridComputePrivateLinkScopePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs =
        com.pulumi.azurenative.hybridcompute.PrivateLinkScopeArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeName(scopeName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkScopeArgs].
 */
@PulumiTagMarker
public class PrivateLinkScopeArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<HybridComputePrivateLinkScopePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location
     */
    @JvmName("clnuwhjyyuvtbrqe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties that define a Azure Arc PrivateLinkScope resource.
     */
    @JvmName("epibaqrrurhxcwpu")
    public suspend fun properties(`value`: Output<HybridComputePrivateLinkScopePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxbknhsqhgucoxpv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("vcmekgeellargkuf")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("yhosuiidvfiqvqdq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("rgsqaubskulgtctq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties that define a Azure Arc PrivateLinkScope resource.
     */
    @JvmName("shihuutdpatudjbe")
    public suspend fun properties(`value`: HybridComputePrivateLinkScopePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties that define a Azure Arc PrivateLinkScope resource.
     */
    @JvmName("fpdkinmahuwkfklh")
    public suspend
    fun properties(argument: suspend HybridComputePrivateLinkScopePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = HybridComputePrivateLinkScopePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sytygiodduosvujl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Arc PrivateLinkScope resource.
     */
    @JvmName("kukrdqnisqfiaogm")
    public suspend fun scopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ptdluxjmgctjlirn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("gihjmaqgxuirqvkc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateLinkScopeArgs = PrivateLinkScopeArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        scopeName = scopeName,
        tags = tags,
    )
}
