@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.HybridComputePrivateLinkScopePropertiesArgs.builder
import com.pulumi.azurenative.hybridcompute.kotlin.enums.PublicNetworkAccessType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties that define a Azure Arc PrivateLinkScope resource.
 * @property publicNetworkAccess Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
 */
public data class HybridComputePrivateLinkScopePropertiesArgs(
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.HybridComputePrivateLinkScopePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcompute.inputs.HybridComputePrivateLinkScopePropertiesArgs =
        com.pulumi.azurenative.hybridcompute.inputs.HybridComputePrivateLinkScopePropertiesArgs.builder()
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [HybridComputePrivateLinkScopePropertiesArgs].
 */
@PulumiTagMarker
public class HybridComputePrivateLinkScopePropertiesArgsBuilder internal constructor() {
    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessType>>? = null

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("guqlcwidccrkqvux")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessType>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("ktkexlmcrildsncm")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("vnotpfjkehmummbm")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
     */
    @JvmName("hxkegpnwgvrunemi")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessType) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): HybridComputePrivateLinkScopePropertiesArgs =
        HybridComputePrivateLinkScopePropertiesArgs(
            publicNetworkAccess = publicNetworkAccess,
        )
}
