@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of a private endpoint connection.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection state of the private endpoint connection.
 */
public data class PrivateEndpointConnectionPropertiesArgs(
    public val privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null,
    public val privateLinkServiceConnectionState:
    Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointConnectionPropertiesArgs =
        com.pulumi.azurenative.hybridcompute.inputs.PrivateEndpointConnectionPropertiesArgs.builder()
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesArgsBuilder internal constructor() {
    private var privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null

    private var privateLinkServiceConnectionState:
        Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("vcywltkwvejbosbm")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointPropertyArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Connection state of the private endpoint connection.
     */
    @JvmName("jjnmwfujbtqwsekv")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStatePropertyArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("trpaqwlmkdyrwuyf")
    public suspend fun privateEndpoint(`value`: PrivateEndpointPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Private endpoint which the connection belongs to.
     */
    @JvmName("ohapqmrhorgcwmun")
    public suspend
    fun privateEndpoint(argument: suspend PrivateEndpointPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Connection state of the private endpoint connection.
     */
    @JvmName("syywlchcenbbtbei")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStatePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Connection state of the private endpoint connection.
     */
    @JvmName("kdsdmwkmymhmrvvj")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStatePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStatePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesArgs =
        PrivateEndpointConnectionPropertiesArgs(
            privateEndpoint = privateEndpoint,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        )
}
