@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.PrivateLinkServiceConnectionStatePropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * State of the private endpoint connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStatePropertyArgs(
    public val description: Output<String>,
    public val status: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.PrivateLinkServiceConnectionStatePropertyArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcompute.inputs.PrivateLinkServiceConnectionStatePropertyArgs =
        com.pulumi.azurenative.hybridcompute.inputs.PrivateLinkServiceConnectionStatePropertyArgs.builder()
            .description(description.applyValue({ args0 -> args0 }))
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStatePropertyArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStatePropertyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("ybhslsqicxeqnkgb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("uaejgrrtwgxpyiyx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("jgcpjiedjylqlvgy")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("dnqroubkbbsuswxt")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStatePropertyArgs =
        PrivateLinkServiceConnectionStatePropertyArgs(
            description = description ?: throw PulumiNullFieldException("description"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
