@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.inputs

import com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the status and behavior of a service.
 * @property startupType The behavior of the service when the Arc-enabled machine starts up.
 * @property status The current status of the service.
 */
public data class ServiceStatusArgs(
    public val startupType: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusArgs =
        com.pulumi.azurenative.hybridcompute.inputs.ServiceStatusArgs.builder()
            .startupType(startupType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceStatusArgs].
 */
@PulumiTagMarker
public class ServiceStatusArgsBuilder internal constructor() {
    private var startupType: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The behavior of the service when the Arc-enabled machine starts up.
     */
    @JvmName("uxbglgnvmsubobgf")
    public suspend fun startupType(`value`: Output<String>) {
        this.startupType = value
    }

    /**
     * @param value The current status of the service.
     */
    @JvmName("jkqijekjnpgduahs")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The behavior of the service when the Arc-enabled machine starts up.
     */
    @JvmName("fixuytupqwapgbhy")
    public suspend fun startupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startupType = mapped
    }

    /**
     * @param value The current status of the service.
     */
    @JvmName("qfmfposbatvkphji")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ServiceStatusArgs = ServiceStatusArgs(
        startupType = startupType,
        status = status,
    )
}
