@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
 * @property configMode Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists and guest configuration, maintained by Microsoft.
 * @property extensionsAllowList Array of extensions that are allowed to be installed or updated.
 * @property extensionsBlockList Array of extensions that are blocked (cannot be installed or updated)
 * @property extensionsEnabled Specifies whether the extension service is enabled or disabled.
 * @property guestConfigurationEnabled Specified whether the guest configuration service is enabled or disabled.
 * @property incomingConnectionsPorts Specifies the list of ports that the agent will be able to listen on.
 * @property proxyBypass List of service names which should not use the specified proxy server.
 * @property proxyUrl Specifies the URL of the proxy to be used.
 */
public data class AgentConfigurationResponse(
    public val configMode: String,
    public val extensionsAllowList: List<ConfigurationExtensionResponse>,
    public val extensionsBlockList: List<ConfigurationExtensionResponse>,
    public val extensionsEnabled: String,
    public val guestConfigurationEnabled: String,
    public val incomingConnectionsPorts: List<String>,
    public val proxyBypass: List<String>,
    public val proxyUrl: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.AgentConfigurationResponse):
            AgentConfigurationResponse = AgentConfigurationResponse(
            configMode = javaType.configMode(),
            extensionsAllowList = javaType.extensionsAllowList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.ConfigurationExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            extensionsBlockList = javaType.extensionsBlockList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.ConfigurationExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            extensionsEnabled = javaType.extensionsEnabled(),
            guestConfigurationEnabled = javaType.guestConfigurationEnabled(),
            incomingConnectionsPorts = javaType.incomingConnectionsPorts().map({ args0 -> args0 }),
            proxyBypass = javaType.proxyBypass().map({ args0 -> args0 }),
            proxyUrl = javaType.proxyUrl(),
        )
    }
}
