@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
 * @property provider Specifies the cloud provider (Azure/AWS/GCP...).
 */
public data class CloudMetadataResponse(
    public val provider: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.CloudMetadataResponse):
            CloudMetadataResponse = CloudMetadataResponse(
            provider = javaType.provider(),
        )
    }
}
