@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a hybrid machine.
 * @property adFqdn Specifies the AD fully qualified display name.
 * @property agentConfiguration Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
 * @property agentUpgrade The info of the machine w.r.t Agent Upgrade
 * @property agentVersion The hybrid machine agent full version.
 * @property clientPublicKey Public Key that the client provides to be used during initial resource onboarding
 * @property cloudMetadata The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
 * @property detectedProperties Detected properties from the machine.
 * @property displayName Specifies the hybrid machine display name.
 * @property dnsFqdn Specifies the DNS fully qualified display name.
 * @property domainName Specifies the Windows domain name.
 * @property errorDetails Details about the error state.
 * @property extensions Machine Extensions information (deprecated field)
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity for the resource.
 * @property lastStatusChange The time of the last status change.
 * @property location The geo-location where the resource lives
 * @property locationData Metadata pertaining to the geographic location of the resource.
 * @property machineFqdn Specifies the hybrid machine FQDN.
 * @property mssqlDiscovered Specifies whether any MS SQL instance is discovered on the machine.
 * @property name The name of the resource
 * @property osName The Operating System running on the hybrid machine.
 * @property osProfile Specifies the operating system settings for the hybrid machine.
 * @property osSku Specifies the Operating System product SKU.
 * @property osType The type of Operating System (windows/linux).
 * @property osVersion The version of Operating System running on the hybrid machine.
 * @property parentClusterResourceId The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
 * @property privateLinkScopeResourceId The resource id of the private link scope this machine is assigned to, if any.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property resources The list of extensions affiliated to the machine
 * @property serviceStatuses Statuses of dependent services that are reported back to ARM.
 * @property status The status of the hybrid machine agent.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmId Specifies the hybrid machine unique ID.
 * @property vmUuid Specifies the Arc Machine's unique SMBIOS ID
 */
public data class GetMachineResult(
    public val adFqdn: String,
    public val agentConfiguration: AgentConfigurationResponse,
    public val agentUpgrade: AgentUpgradeResponse? = null,
    public val agentVersion: String,
    public val clientPublicKey: String? = null,
    public val cloudMetadata: CloudMetadataResponse? = null,
    public val detectedProperties: Map<String, String>,
    public val displayName: String,
    public val dnsFqdn: String,
    public val domainName: String,
    public val errorDetails: List<ErrorDetailResponse>,
    public val extensions: List<MachineExtensionInstanceViewResponse>? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val lastStatusChange: String,
    public val location: String,
    public val locationData: LocationDataResponse? = null,
    public val machineFqdn: String,
    public val mssqlDiscovered: String? = null,
    public val name: String,
    public val osName: String,
    public val osProfile: OSProfileResponse? = null,
    public val osSku: String,
    public val osType: String? = null,
    public val osVersion: String,
    public val parentClusterResourceId: String? = null,
    public val privateLinkScopeResourceId: String? = null,
    public val provisioningState: String,
    public val resources: List<MachineExtensionResponse>,
    public val serviceStatuses: ServiceStatusesResponse? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmId: String? = null,
    public val vmUuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.GetMachineResult):
            GetMachineResult = GetMachineResult(
            adFqdn = javaType.adFqdn(),
            agentConfiguration = javaType.agentConfiguration().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.AgentConfigurationResponse.Companion.toKotlin(args0)
            }),
            agentUpgrade = javaType.agentUpgrade().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.AgentUpgradeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentVersion = javaType.agentVersion(),
            clientPublicKey = javaType.clientPublicKey().map({ args0 -> args0 }).orElse(null),
            cloudMetadata = javaType.cloudMetadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.CloudMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            detectedProperties = javaType.detectedProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            displayName = javaType.displayName(),
            dnsFqdn = javaType.dnsFqdn(),
            domainName = javaType.domainName(),
            errorDetails = javaType.errorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }),
            extensions = javaType.extensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionInstanceViewResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastStatusChange = javaType.lastStatusChange(),
            location = javaType.location(),
            locationData = javaType.locationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.LocationDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            machineFqdn = javaType.machineFqdn(),
            mssqlDiscovered = javaType.mssqlDiscovered().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            osName = javaType.osName(),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.OSProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osSku = javaType.osSku(),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion(),
            parentClusterResourceId = javaType.parentClusterResourceId().map({ args0 -> args0 }).orElse(null),
            privateLinkScopeResourceId = javaType.privateLinkScopeResourceId().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.MachineExtensionResponse.Companion.toKotlin(args0)
                })
            }),
            serviceStatuses = javaType.serviceStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcompute.kotlin.outputs.ServiceStatusesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridcompute.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmId = javaType.vmId().map({ args0 -> args0 }).orElse(null),
            vmUuid = javaType.vmUuid(),
        )
    }
}
