@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties that define a Azure Arc PrivateLinkScope resource.
 * @property privateEndpointConnections The collection of associated Private Endpoint Connections.
 * @property privateLinkScopeId The Guid id of the private link scope.
 * @property provisioningState Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
 * @property publicNetworkAccess Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
 */
public data class HybridComputePrivateLinkScopePropertiesResponse(
    public val privateEndpointConnections: List<PrivateEndpointConnectionDataModelResponse>,
    public val privateLinkScopeId: String,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.HybridComputePrivateLinkScopePropertiesResponse):
            HybridComputePrivateLinkScopePropertiesResponse =
            HybridComputePrivateLinkScopePropertiesResponse(
                privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcompute.kotlin.outputs.PrivateEndpointConnectionDataModelResponse.Companion.toKotlin(args0)
                    })
                }),
                privateLinkScopeId = javaType.privateLinkScopeId(),
                provisioningState = javaType.provisioningState(),
                publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            )
    }
}
