@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata pertaining to the geographic location of the resource.
 * @property city The city or locality where the resource is located.
 * @property countryOrRegion The country or region where the resource is located
 * @property district The district, state, or province where the resource is located.
 * @property name A canonical name for the geographic or physical location.
 */
public data class LocationDataResponse(
    public val city: String? = null,
    public val countryOrRegion: String? = null,
    public val district: String? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcompute.outputs.LocationDataResponse):
            LocationDataResponse = LocationDataResponse(
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            countryOrRegion = javaType.countryOrRegion().map({ args0 -> args0 }).orElse(null),
            district = javaType.district().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
